/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/23, 17:27
!  AUTHOR(S): KOGA, Junichiro
!  File : DrudeTermPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.preparationpanel;

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author
 */
public class DrudeTermPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(GeneralPanel.class.getName());

    /** Creates a new instance of GeneralPanel */
    public DrudeTermPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new SubPanel(projectInfo.getInputInterface()), BorderLayout.NORTH);
    }

    class SubPanel extends PhaseInputItems {
        SubPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        public void createGUI() {
            String[] specdrude = new String[] { "epsilon.drude_term.drude" };
            ChoicePanelPhase drude = new ChoicePanelPhase(specdrude,
                    inputInterface, "drude", ON_OFF, ON_OFF_DUPLI, this);
            String[] specmass = new String[] { "epsilon.drude_term.effective_mass" };
            InputPanelPhase mass = new InputPanelPhase(specmass,
                    inputInterface, "effective mass", InputPanelPhase.NONE, 15,
                    this);
            String[] specdamp = new String[] { "epsilon.drude_term.damping_factor" };
            InputPanelPhase damp = new InputPanelPhase(specdamp,
                    inputInterface, "damping factor", InputPanelPhase.NONE, 15,
                    this);
            String[] speccond = new String[] { "epsilon.drude_term.conductivity" };
            InputPanelPhase cond = new InputPanelPhase(speccond,
                    inputInterface, "conductivity", InputPanelPhase.NONE, 15,
                    this);
            String[] specplasma = new String[] { "epsilon.drude_term.plasma_frequency" };
            InputPanelPhase plasma = new InputPanelPhase(specplasma,
                    inputInterface, "plasma frequency", InputPanelPhase.NONE,
                    15, this);

            JPanel p1 = new JPanel();
            p1.setLayout(new GridLayout(1, 2));
            p1.add(drude);
            p1.add(mass);

            JPanel p2 = new JPanel();
            p2.setLayout(new BoxLayout(p2, BoxLayout.X_AXIS));
            p2.add(damp);
            p2.add(cond);
            p2.add(plasma);

            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
            p.add(p1);
            p.add(p2);

            add(p);
        }

    }
}
