/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : StructuralEvolution.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.CloseButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputChildrenPanel;

public class StructuralEvolution extends PhaseInputChildrenPanel {

    private static Logger logger = Logger.getLogger(StructuralEvolution.class
            .getName());

    public StructuralEvolution(InputInterface inputInterface) {
        super("structural evolution", true, true, true, true, inputInterface,
                new Dimension(480, 280));
    }

    public void createGUI() {
        Container cont = getContentPane();
        cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));

        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

        // method
        JPanel p_strctevl = new JPanel();
        p_strctevl.setLayout(new GridLayout(1, 2, 1, 1));

        String[] specmethod = { "structure_evolution.method" };
        String[] methods = { NO_SELECTION, "quench", "gdiis",
                "velocity_verlet", "cg" };
        ChoicePanelPhase cppmethod = new ChoicePanelPhase(specmethod,
                inputInterface, "method", methods, this);
        p_strctevl.add(cppmethod);

        String[] specdt = { "structure_evolution.dt" };
        InputPanelPhase ippdt = new InputPanelPhase(specdt, inputInterface,
                "dt", InputPanelPhase.NONE, 10, this);
        p_strctevl.add(ippdt);

        p_strctevl.setBorder(new TitledBorder("method"));
        p.add(p_strctevl);

        // gdiis
        JPanel p_gdiis = new JPanel();
        p_gdiis.setLayout(new GridLayout(2, 2, 1, 1));

        String[] specbsize = { "structure_evolution.gdiis.gdiis_box_size" };
        InputPanelPhase ippbsize = new InputPanelPhase(specbsize,
                inputInterface, "gdiis_box_size", InputPanelPhase.NONE, 10,
                this);
        p_gdiis.add(ippbsize);

        String[] spechnew = { "structure_evolution.gdiis.gdiis_hownew" };
        String[] hnews = { NO_SELECTION, "anew", "renew" };
        ChoicePanelPhase cpphnew = new ChoicePanelPhase(spechnew,
                inputInterface, "gdiis_hownew", hnews, this);
        p_gdiis.add(cpphnew);

        String[] specforc = { "structure_evolution.gdiis.c_forc2gdiis" };
        InputPanelPhase ippforc = new InputPanelPhase(specforc, inputInterface,
                "c_forc2gdiis", InputPanelPhase.FORCE, 10, this);
        p_gdiis.add(ippforc);

        String[] specite = { "structure_evolution.gdiis.c_iteration2GDIIS" };
        InputPanelPhase ippite = new InputPanelPhase(specite, inputInterface,
                "c_iteration2GDIIS", InputPanelPhase.NONE, 10, this);
        p_gdiis.add(ippite);
        p_gdiis.setBorder(new TitledBorder("gdiis"));
        p.add(p_gdiis);

        cppmethod.registerDisabableGUI(new int[] { 0, 1, 3, 4 }, ippbsize);
        cppmethod.registerDisabableGUI(new int[] { 0, 1, 3, 4 }, cpphnew);
        cppmethod.registerDisabableGUI(new int[] { 0, 1, 3, 4 }, ippforc);
        cppmethod.registerDisabableGUI(new int[] { 0, 1, 3, 4 }, ippite);

        p.add(Box.createVerticalStrut(10));

        CloseButton close = new CloseButton(this);

        setResizable(true);

        cont.add(p);
        cont.add(close);
    }

    public void delete() {
    }

    public void add() {
    }

    public void save() {
    }
}
