/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/17, 14:54
!  AUTHOR(S): KOGA, Junichiro
!  File : CoordsWizPh.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.Importable;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.input.InputWizardEvent;
import ciss.phase_viewer.input.InputWizardListener;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.ImportButton;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;

/**
 * WwpWizard
 * 
 * @author
 */
public class CoordsWizPh implements InputWizard, Importable, ActionListener,
        TableModelListener, ACVCaller, InputWizardListener {
    private Logger logger = Logger.getLogger(CoordsWizPh.class.getName());

    private JPanel panel;

    private InputInterface input;

    private ImportButton importButton;

    private JTextField selectedFile;

    private boolean hasNext = false;

    private boolean hasFinished = false;

    /** Creates a new instance of CoordsWiz */
    public CoordsWizPh() {
    }

    public String process() {
        if (symmetry.isSelected()) {
            input.getInputInterfacePrimitiveEntry("structure.symmetry.method")
                    .setValue("automatic");
        }
        return "created atomic coordinates";
    }

    public void setInput(Input input) {
        this.input = (InputInterface) input;
    }

    public boolean hasPrevious() {
        return true;
    }

    public boolean hasNext() {
        return hasNext;
    }

    public boolean hasFinished() {
        return hasFinished;
    }

    public String getName() {
        return "atomic coordinates";
    }

    public JPanel getGUI() {
        if (panel == null) {
            createGUI();
        }
        return panel;
    }

    private void update() {
        File file = new File(selectedFile.getText());
        hasNext = file.exists() && file.length() != 0L;
        hasFinished = hasNext;
        metallic.setEnabled(hasNext);
        spin.setEnabled(hasNext);
        symmetry.setEnabled(hasNext);
        parent.update(this);
    }

    private JCheckBox metallic;

    private JCheckBox spin;

    private JCheckBox symmetry;

    private void createGUI() {
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, BoxLayout.X_AXIS));
        selectedFile = new JTextField(15);
        selectedFile.addCaretListener(new CaretListener() {
            public void caretUpdate(CaretEvent e) {
                update();
            }
        });
        importButton = new ImportButton("select coords file", this, this);
        filePanel.add(selectedFile);
        filePanel.add(importButton);
        metallic = new JCheckBox("metallic");
        spin = new JCheckBox("spin");
        symmetry = new JCheckBox("symmetry");
        metallic.setEnabled(false);
        spin.setEnabled(false);
        symmetry.setSelected(true);
        panel.add(filePanel);
        filePanel.add(metallic);
        filePanel.add(spin);
        filePanel.add(symmetry);
    }

    public String getDescription() {
        return "specify/edit atomic coordinates";
    }

    private HashMap properties;

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    private InputWizardController parent;

    public void setParent(InputWizardController parent) {
        this.parent = parent;
        this.parent.addInputWizardListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        ((Command) e.getSource()).execute(e);
    }

    private AtomCoords coords;

    private JPanel atcoordsPanel;

    private void createAtomCoordsPanel() {
        if (atcoordsPanel == null)
            atcoordsPanel = new JPanel();
        atcoordsPanel.removeAll();
        atcoordsPanel.add(getAtomCoordsPanel());
        atcoordsPanel.revalidate();
    }

    public void coordsImported(AtomCoords[] crds, String type, String fileName) {
        selectedFile.setText(fileName);
        if (crds != null && crds.length != 0)
            this.coords = crds[0];

        logger.debug("removing ignore-on-save atoms; curr numat: "
                + coords.getNumAt());
        coords.removeIgnoreOnSaveAtoms();
        coords.convert(AtomCoords.TO_INTERNAL, AtomCoords.TO_BOHR);
        logger.debug("removed ignore-on-save atoms; currnumat: "
                + coords.getNumAt());

        coords.atomCoords2InputInterface(input, atomtag);

        ElementInfo.updateElement(input);
        createAtomCoordsPanel();
        panel.add(atcoordsPanel);
    }

    private void createCoords() {
        coords = new AtomCoords();
        coords.createCellFromTableModel(modCell);
        coords.inputInterface2AtomCoords(input, atomtag);
        coords.setUnit(AtomCoords.BOHR);
        coords.isCart(false);
    }

    private void bootViewer() {
        createCoords();

        String baseDir = new File(input.getFileName()).getParent();
        coords.convert(AtomCoords.TO_CART, AtomCoords.TO_ANG);

        coords.createBravaisLattice((InputInterface) input,
                !BravaisLattice.isBravais((InputInterface) input));
        BravaisLattice bl = coords.getBravaisLattice();

        Vector vec = new Vector();
        vec.addElement(coords);
        ACVData acvdata = new ACVData(this, vec, baseDir, input, atomtag);
        acvdata.setBravaisLattice(bl);
        CoordsViewerBooter cvb = new CoordsViewerBooter(acvdata);
        cvb.boot();
    }

    private String atomtag = StringConstants.phase_atom_tag;

    private TableModel modCell;

    private JComboBox unitCellType;

    private JTable tfatom;

    private JPanel getAtomCoordsPanel() {
        unitCellType = new JComboBox(new String[] { "Bravais", "primitive" });
        JPanel ptype = new JPanel();
        ptype.setBorder(new TitledBorder("unitcell type"));
        ptype.add(unitCellType);
        JButton bootbtn = new JButton("boot viewer");
        JPanel btnpanel = new JPanel();
        btnpanel.add(ptype);
        btnpanel.add(bootbtn);

        unitCellType.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ((InputInterface) input).getInputInterfacePrimitiveEntry(
                        "structure.unit_cell_type").setValue(
                        unitCellType.getSelectedItem().toString());
            }
        });

        unitCellType.setSelectedIndex(0);

        bootbtn.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                bootViewer();
            }
        });

        JPanel p_atom_all = new JPanel();
        p_atom_all.setLayout(new BoxLayout(p_atom_all, BoxLayout.Y_AXIS));

        Cell cell = coords.getCell(0);
        String[][] strcell = cell.getCell();
        String[] tmp = { "structure.unit_cell" };
        TableForInputInterface tfcell = new TableForInputInterface(tmp, input,
                null, this, 0);
        modCell = tfcell.getModel();
        for (int i = 0; i < 3; i++)
            for (int j = 0; j < 3; j++)
                tfcell.setValueAt(strcell[i][j], i, j + 1);

        JPanel pcell = new JPanel();
        pcell.setLayout(new BorderLayout());
        pcell.add(tfcell.getPanel(), BorderLayout.WEST);
        pcell.add(btnpanel, BorderLayout.EAST);
        p_atom_all.add(pcell);

        String[] atmtable = new String[] { atomtag };

        int[] map = { 0, 1, 2, 3, 4 };

        tfatom = new TableForInputInterface(atmtable, input, map, this);
        p_atom_all.add(tfatom);
        JPanel panelAtom = new JPanel();
        panelAtom.setLayout(new BoxLayout(panelAtom, BoxLayout.Y_AXIS));
        panelAtom.add(((TableForInputInterface) tfatom).getPanel());

        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(
                ((TableForInputInterface) tfatom).getPanel());
        scrPane.setPreferredSize(new Dimension(500, 150));
        p_atom_all.add(scrPane);
        p_atom_all.setBorder(new TitledBorder("atomic coordinates"));
        coords.setModels(tfatom.getModel(), null);

        return p_atom_all;
    }

    public void tableChanged(TableModelEvent e) {
        ((Command) e.getSource()).execute(e);
    }

    public void save(AtomCoords crds) {
        this.coords = crds;
        coords.removeIgnoreOnSaveAtoms();
        this.coords.convert(AtomCoords.TO_INTERNAL, AtomCoords.TO_BOHR);
        coords.atomCoords2InputInterface(input, atomtag);
        ElementInfo.updateElement(input);
        createAtomCoordsPanel();
        if (coords.getBravaisLattice() != null) {
            logger.debug("setting unitCellType");
            BravaisLattice blat = coords.getBravaisLattice();
            if (blat.isBravais())
                unitCellType.setSelectedIndex(0);
            else
                unitCellType.setSelectedIndex(1);
        } else {
            logger.debug("bravais lattice is null!");
        }
    }

    public void stateChanged(InputWizardEvent ev) {
        if (ev.getState() == InputWizardEvent.TO_NEXT
                || ev.getState() == InputWizardEvent.TO_PREVIOUS
                || ev.getState() == InputWizardEvent.FINISHING) {
            createCoords();
            properties.put("atomcoords", this.coords);
            properties.put("metallic", String.valueOf(metallic.isSelected()));
            properties.put("spin", String.valueOf(spin.isSelected()));
            ElementInfo.updateElement(input);
        }
    }

}
