/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/21, 13:19
!  AUTHOR(S): KOGA, Junichiro
!  File : SymmetryPointSet.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.fbz;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;

import org.apache.log4j.Logger;

/**
 * Ώ̓_ێBranchGroup
 * 
 * @author
 */
public class SymmetryPointSet extends BranchGroup {
    private Logger logger = Logger.getLogger(SymmetryPointSet.class.getName());

    /** Creates a new instance of SymmetryPointSet */
    public SymmetryPointSet() {
        super();
    }

    public void addChild(Node nd) {
        if (!(nd instanceof SymmetryPointBG)) {
            return;
        }
        SymmetryPointBG symm = (SymmetryPointBG) nd;
        for (int i = 0; i < numChildren(); i++) {
            Node nod = getChild(i);
            if (((SymmetryPointBG) nod).getPos().epsilonEquals(symm.getPos(),
                    0.001f)) {
                return;
            }
        }
        super.addChild(nd);
    }

    /**
     * wΏ̓_擾. getChildƂĂLXĝƓ.
     * 
     * @param i
     *            قΏ̓_iԖ
     * @return w̑Ώ̓_
     */
    public SymmetryPointBG getSymmetryPoint(int i) {
        return (SymmetryPointBG) getChild(i);
    }

}
