/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/13, 21:06
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectDirBrowserRenderer.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import java.awt.Color;
import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.apache.log4j.Logger;

/**
 * 
 * @author KOGA, Junichiro
 */
public class ProjectDirBrowserRenderer extends DefaultTreeCellRenderer {
    private static Logger logger = Logger
            .getLogger(ProjectDirBrowserRenderer.class.getName());

    private Color foregroundColor;
    private Color backgroundColor;

    public ProjectDirBrowserRenderer() {
        super();
        foregroundColor = getForeground();
        backgroundColor = getBackground();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value,
            boolean isSelected, boolean expanded, boolean leaf, int row,
            boolean hasFocus) {
        ProjectDirBrowserNode node = (ProjectDirBrowserNode) value;
        Object obj = node.getUserObject();
        if (obj instanceof ProjectDirBrowserObject) {
            ProjectDirBrowserObject pdbobject = (ProjectDirBrowserObject) obj;
            setText(pdbobject.getText());
            Icon closeIcon = pdbobject.getIcon();
            Icon openIcon = pdbobject.getOpenIcon();
            if (closeIcon != null) {
                setIcon(closeIcon);
                super.leafIcon = closeIcon;
                super.closedIcon = closeIcon;
            }
            if (openIcon != null) {
                super.openIcon = openIcon;
            }
            setOpaque(true);
            if (isSelected) {
                setForeground(Color.red);
                setBackground(Color.cyan);
            } else {
                setForeground(foregroundColor);
                setBackground(backgroundColor);
            }
            return this;
        } else {
            Component comp = super.getTreeCellRendererComponent(tree, value,
                    selected, expanded, leaf, row, hasFocus);
            if (isSelected) {
                comp.setForeground(Color.red);
                comp.setBackground(Color.cyan);
            } else {
                comp.setForeground(Color.black);
                comp.setBackground(Color.white);
            }
            return comp;
        }

    }

}
