/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/22 20:24:54
!  AUTHOR(S): KOGA, Junichiro
!  File : DrawInvertedAtom.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.viewer.view;

import java.awt.event.ActionEvent;

import ciss.phase_viewer.acviewer.ACVAction;
import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;

public class DrawInvertedAtom extends ACVAction {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(DrawInvertedAtom.class.getName());

    public DrawInvertedAtom(BaseJ3DPanel panel) {
        super(panel);
    }

    public void actionPerformed(ActionEvent e) {
        if (!(parent instanceof MainPanel))
            return;

        MainPanel acv = (MainPanel) parent;
        AtomCoords coords = acv.getCD().getAtomCoords();
        acv.getCD().isRenderingManual(true);

        acv.doUnitCell(new Boolean(true), new Boolean(true), null, null, null);

        acv.prepareRedraw();
        coords.saveState();
        coords.removeBoundaryAtoms();

        AtomList atoms = coords.getAtomList();
        int numat = atoms.getNumAt();
        double[] origin = acv.getCD().getCellOriginVector();
        boolean hasinv = false;
        for (int i = 0; i < numat; i++) {
            if (atoms.getAtomAt(i).isInvSymAtom()) {
                hasinv = true;
                break;
            }
        }

        if (hasinv) {
            for (int i = atoms.getNumAt() - 1; i >= 0; i--) {
                if (atoms.getAtomAt(i).isInvSymAtom())
                    atoms.removeAtomAt(i);
            }
        } else {
            for (int i = 0; i < numat; i++) {
                Atom atom = atoms.getAtomAt(i);
                String wei = atom.getProperty("weight");
                logger.debug("origi: " + origin[0] + " " + origin[1] + " "
                        + origin[2]);
                if (wei != null && wei.trim().equals("2")
                        && !atom.isInvSymAtom()) {
                    double[] pos = atom.getDouble();
                    Atom newAtom = atom.getCopy();
                    logger.debug("pos: " + pos[0] + " " + pos[1] + " " + pos[2]);
                    newAtom.setPos(new double[] { -(pos[0]), -(pos[1]),
                            -(pos[2]) });
                    newAtom.isInvSymAtom(true);
                    atoms.addAtom(newAtom);
                }
            }
        }

        acv.getCD().setCoords(coords);
        coords.finalizeState();
        acv.doUnitCell(new Boolean(true), new Boolean(true), null, null, null);

        acv.postRedraw();
        acv.getCD().isRenderingManual(false);

        Cell cell = coords.getCell(0);
        if (cell == null)
            return;
        double[][] cellve = cell.getDouble();

        // check inversion symmetry PBClKv.
        /*
         * AtomList test = atoms.getCopy();
         * 
         * boolean hasInvSym = true; double epsilon = 0.00001; Vector remvec =
         * new Vector(); iloop: for (int i = test.getNumAt() - 1; i >= 1; i--) {
         * Atom at1 = test.getAtomAt(i); double[] pos1 = at1.getDouble(); if
         * (at1.isInvSymAtom() || at1.getProperty("weight") != null &&
         * at1.getProperty("weight").equals("2")) { if (remvec.indexOf(at1) < 0)
         * remvec.add(at1); continue; } for (int j = i - 1; j >= 0; j--) { Atom
         * at2 = test.getAtomAt(j); double[] pos2 = at2.getDouble(); for (int c1
         * = -1; c1 <= 1; c1++) { for (int c2 = -1; c2 <= 1; c2++) { for (int c3
         * = -1; c3 <= 1; c3++) { double[] tmp = new double[3]; for (int ll = 0;
         * ll < 3; ll++) { tmp[ll] = Math.abs(pos1[ll] + pos2[ll] + c1
         * cellve[0][ll] + c2 * cellve[1][ll] + c3 * cellve[2][ll]); } if (
         * c1==0&&c2==0&&c3==-1)
         * logger.info("tmp "+tmp[0]+" "+tmp[1]+" "+tmp[2]+" "+cellve[2][2]); if
         * (tmp[0] < epsilon && tmp[1] < epsilon && tmp[2] < epsilon) { if
         * (remvec.indexOf(at1) < 0) remvec.add(at1); if (remvec.indexOf(at2) <
         * 0) remvec.add(at2); continue iloop; } } } } } }
         * 
         * logger.info("remvec.size(): " + remvec.size() + " numat: " +
         * atoms.getNumAt()); if (remvec.size() == atoms.getNumAt()) {
         * logger.info("the system has inversion symmetry."); } else {
         * logger.info("the system does not have inversion symmetry."); }
         */
    }

}
