/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : PreferenceEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.viewer.prefs.prefseditor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

public class PreferenceEditor extends InternalFrameChase {
    // public class PreferenceEditor extends InternalFrameChase {

    private static Logger logger = Logger.getLogger(PreferenceEditor.class
            .getName());
    protected CoordsViewerInterface mp;
    protected J3DDataManager mACVD;
    protected ConfigDataManager mCD;

    protected ACVEditors editors;

    private Vector panels = new Vector();

    public PreferenceEditor(MainPanel mp, String title, Dimension size) {
        super(title, size);
        this.mp = mp;
        this.mACVD = mp.getJ3DDataManager();
        this.mCD = mp.getCD();
        mp.addDisposeOnExit(this);
    }

    protected JPanel createButtons() {
        JPanel pclose = new JPanel();
        pclose.setLayout(new BoxLayout(pclose, BoxLayout.X_AXIS));
        JButton btnredraw = new JButton("redraw");
        JButton btnsave = new JButton("save");
        JButton btnclose = new JButton("close");
        JButton btnsaveclose = new JButton("save & close");

        pclose.add(btnredraw);
        pclose.add(btnsave);
        pclose.add(btnclose);
        pclose.add(btnsaveclose);

        btnredraw.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                redraw();
            }
        });

        btnsave.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                save();
            }
        });

        btnsaveclose.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                save();
                dispose();
            }
        });

        btnclose.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        return pclose;
    }

    private void redraw() {
        if (editors == null) {
            return;
        }
        editors.setDataToRepository();
        mp.getCD().forceUpdate(true);
        mp.getCD().update();
        // mp.redraw();
        // mp.lightRedraw();
    }

    private void save() {
        if (editors == null) {
            return;
        }
        editors.setDataToRepository();
        mACVD.writeACVData();
        // mCD.updateAtomCoords();
    }

}
