/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/21 18:58:42
!  AUTHOR(S): KOGA, Junichiro
!  File : UnitCellOperations.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.viewer.prefs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.viewer.edit.CrystalSystemEditor;

public class UnitCellOperations extends InternalFrameChase {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(UnitCellOperations.class.getName());

    public UnitCellOperations(MainPanel panel) {
        super("unit cell", new java.awt.Dimension(420, 370));
        panel.addDisposeOnExit(this);

        JTabbedPane pane = new JTabbedPane();

        CrystalSystemEditor edi = new CrystalSystemEditor(panel);
        pane.addTab("crystal system", edi);

        UnitCellOperationsPanel view = new UnitCellOperationsPanel(panel);
        pane.addTab("view", view);

        JPanel btn = new JPanel();
        JButton dismi = new JButton("dismiss");
        btn.add(dismi);

        getContentPane().setLayout(
                new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
        getContentPane().add(pane);
        getContentPane().add(btn);

        dismi.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                dispose();
            }

        });

        setVisible(true);
    }
}
