/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/30, 11:47
!  AUTHOR(S): KOGA, Junichiro
!  File : HbondConfigPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.prefs;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.ColorConfigGUI;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropConfigCheckBox;
import ciss.phase_viewer.settings.PropConfigCombo;
import ciss.phase_viewer.settings.PropConfigTextField;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * f̕`@Ȃǂݒ肷
 * 
 * @author
 */
public class HbondConfigPanel extends InternalFrameChase {
    private Logger logger = Logger.getLogger(HbondConfigPanel.class.getName());
    private J3DPanel parent;

    private GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

    /** Creates a new instance of HbondConfigPanel */
    public HbondConfigPanel(J3DPanel parent) {
        super("Hydrogen bond config", new Dimension(400, 130));
        this.parent = parent;
        this.parent.addDisposeOnExit(this);
        init();
        setVisible(true);
    }

    private PropConfigCheckBox drawHbond;
    private ColorConfigGUI color;
    private PropConfigTextField width;
    private PropConfigCombo pattern;
    private String[] linePattern = { "solid", "dashed", "dotted" };

    private void init() {
        Container container = getContentPane();
        container.setLayout(new BoxLayout(container, BoxLayout.Y_AXIS));
        container.add(createSettings());
        container.add(createButtons());
    }

    private JPanel createSettings() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, BoxLayout.X_AXIS));

        drawHbond = new PropConfigCheckBox("draw H bonds", "hbond_draw_hbonds",
                props);
        JPanel drawPanel = new JPanel();
        drawPanel.setBorder(new TitledBorder(" "));
        drawPanel.add(drawHbond);

        JPanel colorPanel = new JPanel();
        colorPanel.setBorder(new TitledBorder("color"));
        color = new ColorConfigGUI("choose", "hbond_color", props);
        colorPanel.add(color);

        width = new PropConfigTextField(7, PropConfigTextField.FLOAT,
                "hbond_width", props);
        JPanel widthPanel = new JPanel();
        widthPanel.setBorder(new TitledBorder("width"));
        widthPanel.add(width);

        pattern = new PropConfigCombo(linePattern, "hbond_type", props);
        JPanel patternPanel = new JPanel();
        patternPanel.setBorder(new TitledBorder("pattern"));
        patternPanel.add(pattern);

        ret.add(drawHbond);
        ret.add(colorPanel);
        ret.add(widthPanel);
        ret.add(patternPanel);

        drawHbond.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                boolean b = drawHbond.isSelected();
                color.setEnabled(b);
                width.setEnabled(b);
                pattern.setEnabled(b);
            }
        });

        boolean b = drawHbond.isSelected();
        color.setEnabled(b);
        width.setEnabled(b);
        pattern.setEnabled(b);
        return ret;
    }

    private JPanel createButtons() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, BoxLayout.X_AXIS));
        JButton apply = new JButton("apply");
        JButton dismiss = new JButton("dismiss");
        ret.add(apply);
        ret.add(dismiss);

        apply.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                doApply();
            }
        });

        dismiss.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        return ret;
    }

    private void doApply() {
        props.storeProperty();
        if (parent instanceof MainPanel) {
            ((CoordsViewerInterface) parent).lightRedraw();
        }
    }

}
