/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 16:42
!  AUTHOR(S): KOGA, Junichiro
!  File : PreparationAdvancedPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.TabbedProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class PreparationAdvancedPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(PreparationPanel.class.getName());

    /** Creates a new instance of PreparationAdvancedPanel */
    public PreparationAdvancedPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        initComponents();
    }

    private void initComponents() {
        javax.swing.JPanel jPanel5 = new javax.swing.JPanel();
        setLayout(new java.awt.GridLayout(1, 0));
        setBorder(new javax.swing.border.TitledBorder(null,
                "Preparation panel (advanced)",
                javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION,
                new java.awt.Font("MS Sans Serif", 0, 11), new java.awt.Color(
                        0, 0, 102)));
    }

    public void init() {
        if (projectInfo.getInputInterface() == null) {
            String nfinp = projectInfo.getProjectDirectory()
                    + System.getProperty("file.separator")
                    + projectInfo.getChaseFileManager().getFile("F_INP")
                            .getFileName();
            java.net.URL url = PhaseConstants.TABLESPEC;
            DataManager dm = new DataManager(nfinp, url, false);
            dm.parse();
            InputInterface inputInterface = dm.getInputInterface();
            projectInfo.setInputInterface(inputInterface);
        }
        java.net.URL url = getClass()
                .getResource(
                        "/ciss/phase_viewer/plugins/projectmanipulator/phase/tabbed_manipulator_prep_adv.xml");
        add(new TabbedProjectManipulator(url, projectInfo));
    }

    public void initializeProject() {
    }
}
