/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/13, 20:20
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectManipulatorBase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator;

import java.io.File;
import java.net.URL;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.jobcontrol.DefaultScriptCreator;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.atomconfig.ElemPanel;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.ProjectManipulatorSubSelector;

/**
 * PHASECNȃvȌ𐧌䂷GUĨx[XNX.
 * 
 * @author KOGA, Junichiro
 */
public abstract class ProjectManipulatorBase extends ProjectManipulator
        implements DefaultScriptCreator {
    private static Logger logger = Logger.getLogger(PhaseManipulator.class
            .getName());
    private JSplitPane splitpane;
    protected String baseDir;

    /** Creates a new instance of PhaseManipulator */
    public ProjectManipulatorBase(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void recreate() {
        init();
    }

    public void init() {
        removeAll();
        baseDir = projectInfo.getProjectDirectory();
        // read file_names.data, and create file_info parser objecs.
        // FileInfoParser parser = getFileInfoParser();
        // projectInfo.setFileInfoParser(parser);
        projectInfo.setDefaultScriptCreator(this);
        projectInfo.setProjectDescriptionURL(getProgramDescriptionURL());
        projectInfo.setStdoutGUIs(getStdoutGUIs());

        // then read phase-viewer.xml
        String chaseXML = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator") + "phase-viewer.xml";
        File filechaseXML = new File(chaseXML);
        Document doc = ciss.phase_viewer.jdom.XMLUtils
                .getDocumentFromFile(filechaseXML);
        if (doc == null) {
            java.net.URL defchaseXML = getClass()
                    .getResource(
                            "/ciss/phase_viewer/plugins/projectmanipulator/phase/phase-viewer.xml");
            doc = ciss.phase_viewer.jdom.XMLUtils
                    .getDocumentFromURL(defchaseXML);
            File tmp = new File(projectInfo.getProjectDirectory());
            if (!tmp.exists() && !tmp.mkdirs()) {
                logger.error("failed to create project directory...");
                return;
            }
            String projchaseXML = projectInfo.getProjectDirectory()
                    + System.getProperty("file.separator") + "phase-viewer.xml";
            String type = getType();
            Element typeElem = new Element("type").setText(type);
            doc.getRootElement().addContent(typeElem);
            ciss.phase_viewer.jdom.XMLUtils.saveDocumentTo(doc, new File(
                    projchaseXML));
        }
        projectInfo.setProjectPropertyDocument(doc);

        ChaseFileManager chaseFileManager = getChaseFileManager();
        projectInfo.setChaseFileManager(chaseFileManager);

        // create the GUI.
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        // setBorder(new TitledBorder("manipulate phase"));
        splitpane = new JSplitPane();
        JPanel panel = new JPanel();
        ProjectManipulatorSubSelector subSelector = getProjectManipulatorSubSelector();
        panel.add(subSelector);
        if (subSelector.getLayoutPolicy() == ProjectManipulatorSubSelector.VERTICAL) {
            splitpane.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
            splitpane.setLeftComponent(panel);
        } else {
            splitpane.setOrientation(JSplitPane.VERTICAL_SPLIT);
            splitpane.setTopComponent(panel);
        }
        add(splitpane);

        ElemPanel ele = new ElemPanel(projectInfo);
        projectInfo.registerGUI(ele);
    }

    /**
     * ProjectManipulatorSubSelector̐߂XMLt@CURLԂ.
     * 
     * @return L̒ʂ
     */
    protected abstract URL getSubSelectorURL();

    private ProjectManipulatorSubSelector getProjectManipulatorSubSelector() {
        URL property = getSubSelectorURL();
        ProjectManipulatorSubSelector selector = new ProjectManipulatorSubSelector(
                property, super.projectInfo, splitpane);
        return selector;
    }

    /**
     * ̃vO̐ȂǂLqĂhtmlt@CւURLԂ.
     * 
     * @return L̒ʂ
     */
    protected abstract URL getProgramDescriptionURL();

    /**
     * uChaseFileManagervconcreteȃIuWFNg쐬ĕԂ.
     * 
     * @return L̒ʂ
     */
    protected abstract ChaseFileManager getChaseFileManager();

    /**
     * ʗp̕Ԃ
     * 
     * @return ̃IuWFNg̎ʗp
     */
    protected abstract String getType();

    /**
     * Wo͕\pGUIClass擾
     */
    protected abstract Class[] getStdoutGUIs();

    public boolean postProcess() {
        if (projectInfo.getInputDataManager() != null) {
            DataManager dma = projectInfo.getInputDataManager();
            dma.unregisterFromFileStateObserver();
        }
        return super.postProcess();
    }

}
