/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ProgressBar.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.install;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class ProgressBar extends JPanel {

    public final static int HUNDRED_MILLI_SECOND = 100;
    public final static int ONE_SECOND = 1;

    private JProgressBar progressBar;
    private Timer timer;
    private JButton startButton;
    private JTextArea taskOutput;
    private String newline = System.getProperty("line.separator");

    private Installer installer;

    public ProgressBar(Installer installer) {
        super(new BorderLayout());
        this.installer = installer;

        progressBar = new JProgressBar(0, installer.getNumTasks());
        progressBar.setValue(0);
        progressBar.setStringPainted(true);

        System.out.println("progress bar initiated");
        System.out.println("number of tasks: " + installer.getNumTasks());

        taskOutput = new JTextArea(5, 20);
        taskOutput.setMargin(new Insets(5, 5, 5, 5));
        taskOutput.setEditable(false);
        // taskOutput.setCursor(null); //inherit the panel's cursor
        // see bug 4851758

        JPanel panel = new JPanel();
        panel.add(progressBar);

        add(panel, BorderLayout.PAGE_START);
        add(new JScrollPane(taskOutput), BorderLayout.CENTER);
        setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));

        // Create a timer.
        timer = new Timer(ONE_SECOND, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                update();
            }
        });

    }

    protected void go() {
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        timer.start();
    }

    /**
     * 
     * @uml.property name="timer"
     */
    protected Timer getTimer() {
        return this.timer;
    }

    private void update() {
        progressBar.setValue(installer.getCurrent());
        // System.out.println("---------- from progressbar -----------");
        // System.out.println(installer.getCurrent());
        // String s = installer.getMessage();
        // if (s != null) {
        // taskOutput.append(s + newline);
        // taskOutput.setCaretPosition(
        // taskOutput.getDocument().getLength());
        // }
        // if (installer.isDone()) {
        // Toolkit.getDefaultToolkit().beep();
        // timer.stop();
        // setCursor(null); //turn off the wait cursor
        // }
    }

}
