/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2007/04/17 21:16:49
!  AUTHOR(S): KOGA, Junichiro
!  File : Utils.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.inputinterface;

import org.apache.log4j.Logger;

public class Utils {
    private Logger logger = Logger.getLogger(Utils.class.getName());

    /**
     * ԍŏ̕啶ɂ.
     * 
     * @param input
     *            啶ɂ
     * @return ꕶڂ啶ƂȂ
     */
    public static String firstLetterCaps(String input) {
        if (input == null) {
            return input;
        }
        String ret = input;
        char[] ch = input.toCharArray();
        if (ch != null && ch.length != 0) {
            ch[0] = Character.toUpperCase(ch[0]);
            ret = new String(ch, 0, ch.length);
        }
        return ret;
    }

    /**
     * _uNH[e[Vň͂܂ꂽ̃_uNH[e[VƂ̂.
     * 
     * @param path
     *            _uNH[e[V菜.
     */
    public static String stripDQ(String path) {
        return path.trim().replaceAll("\"", "");
    }

    /**
     * Ƃ镶񂪃_uNH[głĂ邩ǂ
     */
    public static boolean isDoubleQuoted(String foo) {
        return foo.trim().startsWith("\"") && foo.trim().endsWith("\"");
    }

}
