/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/05, 16:03
!  AUTHOR(S): KOGA, Junichiro
!  File : RegExpedString.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.common;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

/**
 * 
 * @author KOGA, Junichiro
 */
public class RegExpedString {
    private Logger logger = Logger.getLogger(RegExpedString.class.getName());
    private String string;
    private boolean hasRegExp = false;
    private String replaceString = "";

    /** Creates a new instance of RegExpedString */
    public RegExpedString(String string) {
        this.string = string;
    }

    public RegExpedString(String string, boolean hasRegExp) {
        this.string = string;
        this.hasRegExp = hasRegExp;
    }

    public RegExpedString(String string, boolean hasRegExp, String replaceString) {
        this.string = string;
        this.hasRegExp = hasRegExp;
        this.replaceString = replaceString;
    }

    /**
     * org.jdom.Element쐬; <foo hasRegExp="true" replace_string="foobar">
     * value </foo>݂ȍ\z肵Ă.
     */
    public RegExpedString(Element element) {
        Attribute rattr = element.getAttribute("hasregexp");
        Attribute replattr = element.getAttribute("replace_string");
        string = element.getTextTrim();
        if (rattr != null) {
            hasRegExp = rattr.getValue().equals("true");
        }
        if (replattr != null) {
            replaceString = replattr.getValue();
        }
    }

    public String getValue() {
        return this.string;
    }

    public boolean hasRegExp() {
        return this.hasRegExp;
    }

    public String getReplaceString() {
        return replaceString;
    }

    public String getDefault() {
        if (this.hasRegExp()) {
            return replaceString;
        } else {
            return this.string;
        }
    }

    public String toString() {
        // String retValue =
        // "value: "+string+", hasRegExp: "+String.valueOf(hasRegExp);
        return this.string;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return equalsString((String) obj);
        } else if (obj instanceof RegExpedString) {
            return ((RegExpedString) obj).getValue().equals(this.string);
        }

        return false;
    }

    private boolean equalsString(String comp) {
        if (hasRegExp) {
            boolean matches = false;
            logger.debug("testing if " + string + " and " + comp
                    + " matches ...");
            matches = comp.matches(string);
            if (matches) {
                logger.debug("yes.");
            } else {
                logger.debug("no.");
            }
            return matches;
        } else {
            return string.equals(comp);
        }
    }
}
