/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/12 16:54:11
!  AUTHOR(S): KOGA, Junichiro
!  File : Tetragonal.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.atomcoord.symmetry;

public class Tetragonal extends BravaisLattice {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(Tetragonal.class.getName());

    public String getName() {
        return latticeSystem + " tetragonal";
    }

    public double[][] getPrimitiveLatticeVector() {
        if (latticeSystem.equals(PRIMITIVE))
            return new double[][] { { a, 0, 0 }, { 0, b, 0 }, { 0, 0, c } };
        if (latticeSystem.equals(BODY_CENTERED))
            return new double[][] { { -0.5 * a, 0.5 * b, 0.5 * c },
                    { 0.5 * a, -0.5 * b, 0.5 * c },
                    { 0.5 * a, 0.5 * b, -0.5 * c } };
        // ɂ͂Ȃ, ͂.
        return null;
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha,
            double beta, double gamma) {
        boolean checkLength = (epsilonEquals(a, b) && !epsilonEquals(a, c))
                || (epsilonEquals(a, c) && !epsilonEquals(a, b))
                || (epsilonEquals(b, c) && !epsilonEquals(a, b));
        boolean checkAngle = epsilonEquals(alpha, 90)
                && epsilonEquals(beta, 90) && epsilonEquals(gamma, 90);
        return checkLength && checkAngle;
    }

    public String[] getLatticeSystemCandidate() {
        return new String[] { PRIMITIVE, BODY_CENTERED };
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec,
            double[] bvec, double[] cvec) {
        if (epsilonEquals(a, b) && !epsilonEquals(a, c)
                && epsilonEquals(alpha, 90) && epsilonEquals(beta, 90)
                && epsilonEquals(gamma, 90)) {
            latticeSystem = PRIMITIVE;
            return this;
        }

        boolean b1 = epsilonEquals(-avec[0], avec[1])
                && !epsilonEquals(avec[1], avec[2])
                && epsilonEquals(-bvec[0], bvec[1])
                && !epsilonEquals(bvec[0], bvec[2])
                && epsilonEquals(cvec[0], cvec[1])
                && !epsilonEquals(cvec[1], -cvec[2]);
        boolean b2 = epsilonEquals(-avec[0], bvec[0])
                && epsilonEquals(bvec[0], cvec[0])
                && epsilonEquals(avec[2], bvec[2])
                && epsilonEquals(bvec[2], -cvec[2]);
        logger.debug("b1 and b2 " + b1 + " " + b2);
        if (b1 && b2) {
            Tetragonal tet = new Tetragonal();
            tet.a = 2 * bvec[0];
            tet.b = tet.a;
            tet.c = 2 * bvec[2];
            tet.alpha = tet.gamma = tet.beta = 90;
            tet.latticeSystem = BODY_CENTERED;
            return tet;
        }

        return null;
    }

    public String getCrystalSystem() {
        return "tetragonal";
    }

}
