/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/25, 17:49
!  AUTHOR(S): KOGA, Junichiro
!  File : XYZExporter.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord.io;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

import javax.swing.filechooser.FileFilter;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;

/**
 * AtomCoordsIuWFNgXYZ`ɃGNX|[g. s: q s(ꉞcell): ax ay az bx by bz cx cy
 * cz (\ȏꍇ) Osڈȍ~: elemname posx posy posz forcx forcy forcz (if force is
 * available)
 * 
 * @author
 */
public class CIFExporter implements Exporter {
	private Logger logger = Logger.getLogger(CIFExporter.class.getName());

	/** Creates a new instance of XYZExporter */
	public CIFExporter() {
	}

	public boolean writeAtomCoordsTo(ciss.phase_viewer.atomcoord.AtomCoords[] coords, String fileName) {
		int nframe = coords.length;

		PrintWriter writer = null;
		try {
			writer = new PrintWriter(new File(fileName));
		} catch (FileNotFoundException fnf) {
			return false;
		}
		for (int i = 0; i < nframe; i++) {
			AtomCoords coor = coords[i];
			// coor.convertCell(Cell.CELL_ABC);
			boolean ret = writeAtomCoordsTo(coor, writer, i);
			if (!ret) {
				writer.close();
				return false;
			}
		}
		writer.close();
		return true;
	}

	private boolean writeAtomCoordsTo(AtomCoords coor, PrintWriter writer, int i) {
		writer.println("data_frame" + String.valueOf(i));
		double[][] latvec = coor.getCell(1).getDouble();
		if (latvec == null || latvec.length != 2 || latvec[0].length != 3 || latvec[1].length != 3)
			return false;

		AtomCoords coo = coor.getCopy();
		coo.convertCell(Cell.CELL_ABC);
		coo.convert(AtomCoords.TO_INTERNAL, AtomCoords.TO_ANG);

		writer.println("_symmetry_cell_setting triclinic");
		writer.println("_symmetry_space_group_name_H-M  'P1'");
		writer.println("_symmetry_Int_Tables_number  1");
		writer.println("_cell_length_a " + String.valueOf(latvec[0][0]));
		writer.println("_cell_length_b " + String.valueOf(latvec[0][1]));
		writer.println("_cell_length_c " + String.valueOf(latvec[0][2]));
		writer.println("_cell_angle_alpha " + String.valueOf(latvec[1][0]));
		writer.println("_cell_angle_beta  " + String.valueOf(latvec[1][1]));
		writer.println("_cell_angle_gamma " + String.valueOf(latvec[1][2]));

		int nat = coo.getNumAt();
		writer.println("loop_");
		writer.println("    _atom_site_label");
		writer.println("    _atom_site_fract_x");
		writer.println("    _atom_site_fract_y");
		writer.println("    _atom_site_fract_z");
		writer.println("    _atom_site_type_symbol");
		writer.println("    _atom_site_occupancy");

		for (int iat = 0; iat < nat; iat++) {
			Atom atom = coo.getAtomList().getAtomAt(iat);
			String elem = atom.getElementName();
			String[] pos = atom.getPos();
			writer.println(elem + " " + pos[0] + " " + pos[1] + " " + pos[2] + " " + elem + " 0");
		}

		return true;
	}

	public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {

	}

	public boolean hasOptions() {
		return false;
	}

	public String getType() {
		return "CIF";
	}

	public javax.swing.filechooser.FileFilter getFileFilter() {
		return new CIFFileFilter();
	}

	public void setOptions(java.util.HashMap options) {
	}

}

class CIFFileFilter extends FileFilter {

	@Override
	public boolean accept(File arg0) {
		return true;
	}

	@Override
	public String getDescription() {
		return "CIF";
	}

}
