/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : JavaScriptTokenMarker.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.pub.jeditsyntax;

/**
 * JavaScript token marker.
 * 
 * @author Slava Pestov
 * @version $Id: JavaScriptTokenMarker.java,v 1.3 1999/12/13 03:40:29 sp Exp $
 */
public class JavaScriptTokenMarker extends CTokenMarker {
    public JavaScriptTokenMarker() {
        super(false, getKeywords());
    }

    public static KeywordMap getKeywords() {
        if (javaScriptKeywords == null) {
            javaScriptKeywords = new KeywordMap(false);
            javaScriptKeywords.add("function", Token.KEYWORD3);
            javaScriptKeywords.add("var", Token.KEYWORD3);
            javaScriptKeywords.add("else", Token.KEYWORD1);
            javaScriptKeywords.add("for", Token.KEYWORD1);
            javaScriptKeywords.add("if", Token.KEYWORD1);
            javaScriptKeywords.add("in", Token.KEYWORD1);
            javaScriptKeywords.add("new", Token.KEYWORD1);
            javaScriptKeywords.add("return", Token.KEYWORD1);
            javaScriptKeywords.add("while", Token.KEYWORD1);
            javaScriptKeywords.add("with", Token.KEYWORD1);
            javaScriptKeywords.add("break", Token.KEYWORD1);
            javaScriptKeywords.add("case", Token.KEYWORD1);
            javaScriptKeywords.add("continue", Token.KEYWORD1);
            javaScriptKeywords.add("default", Token.KEYWORD1);
            javaScriptKeywords.add("false", Token.LABEL);
            javaScriptKeywords.add("this", Token.LABEL);
            javaScriptKeywords.add("true", Token.LABEL);
        }
        return javaScriptKeywords;
    }

    // private members
    private static KeywordMap javaScriptKeywords;
}
