/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/14, 18:14
!  AUTHOR(S): KOGA, Junichiro
!  File : ColorButton.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.vecmath.Color3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.Desk;

/**
 * FIɗpJButton.
 * 
 * @author
 */
public class ColorButton extends JButton {
    private Logger logger = Logger.getLogger(ColorButton.class.getName());

    /** Creates a new instance of ColorButton */
    public ColorButton(String text, Color color) {
        super(text);
        setBackground(color);
        addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                JColorChooser colorchooser = new JColorChooser();
                Color col = getBackground();
                Color color = colorchooser.showDialog(Desk.getDesktop(),
                        "Choose", col);
                if (color != null) {
                    setBackground(color);
                    setForeground(new Color(255 - color.getRed(),
                            255 - color.getGreen(), 255 - color.getBlue()));
                }
            }
        });
    }

    public ColorButton(String text) {
        super(text);
        addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                JColorChooser colorchooser = new JColorChooser();
                Color col = getBackground();
                Color color = colorchooser.showDialog(null, "Choose", col);
                if (color != null) {
                    setBackground(color);
                    setForeground(new Color(255 - color.getRed(),
                            255 - color.getGreen(), 255 - color.getBlue()));
                }
            }
        });
    }

    public Logger getLogger() {
        return logger;
    }

    /**
     * GUȊIF擾. getBackground()ĂԂ̂Ɠ.
     * 
     * @return GUȊIF
     */
    public Color getColor() {
        return getBackground();
    }

    /**
     * GUȊIF, Color3fƂĎ擾
     * 
     * @return GUȊIFColor3fIuWFNg
     */
    public Color3f getColor3f() {
        Color color = getBackground();
        return new Color3f((float) color.getRed() / 255.f,
                (float) color.getGreen() / 255.f,
                (float) color.getBlue() / 255.f);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    /**
     * GUȊIF, Color3fŃZbg.
     * 
     * @param color3f
     *            ZbgF
     */
    public void setColor3f(Color3f color3f) {
        setColorf(color3f.x, color3f.y, color3f.z);
    }

    /**
     * GUȊIF, floatŃZbg.
     * 
     * @param r
     *            
     * @param g
     *            
     * @param b
     *            
     */
    public void setColorf(float r, float g, float b) {
        setBackground(new Color(r, g, b));
        setForeground(new Color(1f - r, 1f - g, 1f - b));
    }

}
