/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/06, 19:16
!  AUTHOR(S): KOGA, Junichiro
!  File : EpsOutPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;

/**
 * ohvŽʂ肷pl.
 * 
 * @author
 */
public class EpsOutPanel extends ProjectManipulator implements
        OutputParserListener {
    private Logger logger = Logger.getLogger(EpsOutPanel.class.getName());
    private OutputParser parser;

    /** Creates a new instance of BanedPanel */
    public EpsOutPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    }

    public void recreate() {
        projectInfo.getOutputInterface().initCache();
        init();
        revalidate();
    }

    public void parseFinished() {
        removeAll();
        JPanel button = new JPanel();
        button.setBorder(new TitledBorder("eps.pl"));
        button.setLayout(new FlowLayout());
        JButton btnepspl = new JButton("run eps.pl");
        // button.add(btnepspl);
        // ComboButton cbeps = new
        // ComboButton(projectInfo.getProjectDirectory(),"eps.eps");
        // button.add(cbeps);
        // add(button);

        JPanel dataPanel = projectInfo.getOutputInterface().getDataPanel(
                "F_EPSOUT");
        add(dataPanel);

        revalidate();

        btnepspl.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                bootEpsPlPanel();
            }
        });
    }

    public void initializeProject() {
    }

    public void init() {
        removeAll();
        String fname = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator")
                + projectInfo.getChaseFileManager().getFile("F_EPSOUT")
                        .getFileName();
        if (!new File(fname).exists()) {
            add(new NoFilePanel("F_EPSOUT"));
            return;
        }
        add(new LoadingFilePanel("F_EPSOUT"));
        if (parser == null) {
            parser = projectInfo.getOutputInterface().getParser("F_EPSOUT",
                    this);
        }
        parser.setParsed(false);
        parser.doParse();
    }

    private JPanel createEpsOutPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        JPanel panelmode = new JPanel();
        panelmode.setLayout(new BoxLayout(panelmode, BoxLayout.X_AXIS));
        String[] modes = { "total", "atom", "layer" };
        JComboBox checkMode = new JComboBox(modes);
        InputPanel width = new InputPanel("width", 0, 5);
        JCheckBox checkFermi = new JCheckBox("with_fermi");
        JCheckBox checkColor = new JCheckBox("");
        return panel;
    }

    private void bootEpsPlPanel() {
        // String dirString = projectInfo.getProjectDirectory();
        // String banddata =
        // projectInfo.getFileInfoParser().getFileInfo("F_ENERG").getName();
        // BandPlPanel bpp = new BandPlPanel("run band.pl",dirString,banddata);
        // bpp.setVisible(true);
    }

}
