/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/10, 20:14
!  AUTHOR(S): KOGA, Junichiro
!  File : MDConfig.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.AddButton;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.DeleteButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;

/**
 * q͊wV~[VݒpGUI
 */
public class MDConfig extends InternalFrameChase {
    private Logger logger = Logger.getLogger(MDConfig.class.getName());
    private ProjectInfo projectInfo;
    private InputInterface inputInterface;
    private MDPanel pan;

    /** Creates a new instance of MDConfig */
    public MDConfig(ProjectInfo projectInfo) {
        super("MD config", true, true, true, true, new Dimension(550, 480));
        try {
            this.projectInfo = projectInfo;
            this.inputInterface = projectInfo.getInputInterface();
            JPanel p = new JPanel();
            pan = new MDPanel(inputInterface);
            p.add(pan);
            getContentPane().add(p);
            addInternalFrameListener(new InternalFrameAdapter() {
                public void internalFrameClosed(InternalFrameEvent e) {
                    pan.exit();
                }
            });
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    class MDPanel extends PhaseInputItems {
        MDPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        private TableForInputInterface tfii;

        public void createGUI() {
            JPanel panel = new JPanel();

            String[] initvel = new String[] { "structure_evolution.temperature_control.set_initial_velocity" };
            ChoicePanelPhase cppinitvel = new ChoicePanelPhase(initvel,
                    inputInterface, "set initial velocity", ON_OFF,
                    ON_OFF_DUPLI, this);
            panel.add(cppinitvel);

            panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
            String[] thermo_spec = new String[] { "structure_evolution.temperature_control.thermostat" };
            String[] dummyArray = new String[] { "" };
            TableForInputInterface thermostat_table = new TableForInputInterface(
                    thermo_spec, inputInterface, this);
            JScrollPane scr_thermo = new JScrollPane();
            scr_thermo.getViewport().setView(thermostat_table.getPanel());
            scr_thermo.setPreferredSize(new Dimension(500, 75));
            JPanel pscrthermo = new JPanel();
            pscrthermo.setBorder(new TitledBorder("registered thermostats"));
            pscrthermo.add(scr_thermo);
            panel.add(pscrthermo);

            JPanel p_new_thermo = new JPanel();
            p_new_thermo
                    .setLayout(new BoxLayout(p_new_thermo, BoxLayout.Y_AXIS));
            p_new_thermo.setBorder(new TitledBorder("new thermostat"));
            InputPanelPhase ipp_temp = new InputPanelPhase(dummyArray,
                    inputInterface, "temp", InputPanelPhase.NONE, 10);
            InputPanelPhase ipp_qmass = new InputPanelPhase(dummyArray,
                    inputInterface, "qmass", InputPanelPhase.NONE, 10);
            JPanel new_thermo = new JPanel();
            new_thermo.setLayout(new BoxLayout(new_thermo, BoxLayout.X_AXIS));
            new_thermo.add(ipp_temp);
            new_thermo.add(ipp_qmass);
            p_new_thermo.add(new_thermo);

            PhaseInputPanelInterface[] thermo_guis = { null, ipp_temp,
                    ipp_qmass };
            AddButton add_hubbard = new AddButton(thermostat_table,
                    thermo_guis, this);
            DeleteButton delete_hubbard = new DeleteButton(thermostat_table,
                    this);
            JButton thermo_from_file = new JButton("from file");
            thermo_from_file.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent ae) {
                    fromFile("structure_evolution.temperature_control",
                            "thermostat");
                }
            });
            JPanel thermo_btn = new JPanel();
            thermo_btn.setLayout(new BoxLayout(thermo_btn, BoxLayout.X_AXIS));
            thermo_btn.add(add_hubbard);
            thermo_btn.add(delete_hubbard);
            thermo_btn.add(thermo_from_file);
            p_new_thermo.add(thermo_btn);

            panel.add(p_new_thermo);

            JScrollPane scr = new JScrollPane();
            String[] atmtable = new String[] { "structure.atom_list.atoms" };
            int[] map = { 0, 1, 2, 3, 4, 9 };
            tfii = new TableForInputInterface(atmtable, inputInterface, map,
                    this);
            scr.getViewport().setView(tfii.getPanel());
            scr.setPreferredSize(new Dimension(500, 150));
            panel.add(scr);

            JPanel btn = new JPanel();
            JButton dismiss = new JButton("dismiss");
            dismiss.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    dispose();
                }
            });
            btn.add(dismiss);
            panel.add(btn);

            add(panel);
        }

        void exit() {
            inputInterface
                    .removeInputInterfaceEntryChangeListener((InputInterfaceEntryChangeListener) tfii
                            .getModel());
        }
    }

}
