/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/07, 17:46
!  AUTHOR(S): KOGA, Junichiro
!  File : OutputData.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.outputinterface;

import org.apache.log4j.Logger;

/**
 * o̓f[^JvZNX.
 * 
 * @author
 */
public class OutputData {
    private Logger logger = Logger.getLogger(OutputData.class.getName());

    private String name = "";
    private String description = "";
    private String[] identifier;
    private String[][] data2d;
    private int numRows;
    private int numCols;
    private String header = "";

    private String fileName = "";

    /**
     * ɏȂǂ͍sȂRXgN^[. 𗘗pꍇ, setterłׂlZbg邱.
     */
    public OutputData() {
    }

    /**
     * KvƎvʂw肷RXgN^[.
     * 
     * @param name
     *            ̃f[^̖O
     * @param description
     *            ̃f[^̐(^ũc[`bvȂǂɗp)
     * @param identifier
     *            ̃f[^̎ʎq; f[^̗̐Ɠɂ邱Ƃ]܂.
     * @param data2d
     *            f[^̂. 񎟌̕z, vfs, vfɑΉ.
     * @param header
     *            f[^̃wb_[. Ȃ΂Ȃł悢.
     */
    public OutputData(String name, String description, String[] identifier,
            String[][] data2d, String header) {
        this.name = name;
        this.description = description;
        setIdentifier(identifier);
        setData2D(data2d);
        this.header = header;
    }

    /**
     * ̃f[^̖OԂ. ^ũeLXgȂ񂩂Ɏg\.
     * 
     * @return ̃f[^̖O.
     */
    public String getName() {
        return name;
    }

    /**
     * ̃f[^̖OZbg. ^ũeLXgȂ񂩂Ɏg\.
     * 
     * @param ̃f[^̖O
     *            .
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * ̃f[^ɊւԂ. ^ũc[`bvȂ񂩂ɗp\.
     * 
     * @return f[^̊ȒPȐ.
     */
    public String getDescription() {
        return description;
    }

    /**
     * ̃f[^ɊւZbg. ^ũc[`bvȂ񂩂ɗp\.
     * 
     * @param f[^̊ȒPȐ
     *            . sȂǂ͑ӖȂ̂œȂ.
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * f[^̎ʎq, zŎ擾. e[uJȂǂɗp.
     * 
     * @param f[^̎ʎqz
     *            .
     */
    public String[] getIdentifier() {
        return identifier;
    }

    /**
     * f[^̎ʎqZbg. ̔z̑傫J`̂ consistentɂȂ悤ȔzZbg.
     * 
     * @param f[^̎ʎqz
     *            .
     */
    public void setIdentifier(String[] identifier) {
        this.identifier = identifier;
        if (identifier != null && identifier.length != 0) {
            numCols = identifier.length;
        }
    }

    /**
     * u񎟌̃f[^v擾.
     * 
     * @return 񎟌f[^
     */
    public String[][] getData2D() {
        return data2d;
    }

    /**
     * u񎟌f[^vZbg. ̏񂩂s̐ݒ肷̂łƂ f[^邱.
     * 
     * @param 񎟌f[^
     */
    public void setData2D(String[][] data2d) {
        this.data2d = data2d;
        if (data2d != null && data2d.length != 0) {
            numRows = data2d.length;
        }
    }

    /**
     * f[^̍s̐Ԃ.
     * 
     * @return s̐.
     */
    public int getNumRows() {
        return numRows;
    }

    /**
     * f[^̗̐Ԃ.
     * 
     * @return f[^̗̐.
     */
    public int getNumCols() {
        return numCols;
    }

    /**
     * ̃f[^̃wb_[擾.
     * 
     * @return f[^̃wb_[.
     */
    public String getHeader() {
        return header;
    }

    /**
     * ̃f[^̃wb_[ݒ肷.
     * 
     * @param header̃f[^̃wb_[
     *            .
     */
    public void setHeader(String header) {
        this.header = header;
    }

    /**
     * ̃f[^, Ǎ̃t@CZbg.
     * 
     * @param fileName
     *            t@C
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * ̃f[^, Ǎ̃t@CQbg.
     * 
     * @return t@C
     */
    public String getFileName() {
        return fileName;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < data2d.length; i++) {
            for (int j = 0; j < data2d[i].length; j++) {
                ret += data2d[i][j] + " ";
            }
            ret += System.getProperty("line.separator");
        }
        return ret;
    }
}
