/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InputInterfaceEntry.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.inputinterface;

import java.util.Stack;

abstract public class InputInterfaceEntry implements InputInterfaceData {

    public static final int PRIMITIVE = 0;
    public static final int TABLE = 1;
    public static final int DEFAULTS = 2;
    public static final int UNITS = 3;
    public static final int BLOCK_END = 4;

    protected String fullName = "";

    protected String name = "";
    protected boolean ignore = false;

    protected Stack undoStack = new Stack();
    protected Stack redoStack = new Stack();

    public InputInterfaceEntry() {
    }

    public InputInterfaceEntry(String name) {
        this.name = name;
    }

    public InputInterfaceEntry(String name, String fullName) {
        this.name = name;
        this.fullName = fullName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    /**
     * returns the 'full name' for this block. a 'full name' is something like
     * structure.atom_list.atoms
     * 
     * @return the fullname string.
     */
    public String getFullName() {
        return this.fullName;
    }

    public boolean isBlock() {
        return false;
    }

    public boolean ignoreMe() {
        return ignore;
    }

    public void ignoreMe(boolean ignore) {
        this.ignore = ignore;
    }

    abstract public int getEntryType();

    abstract public boolean equals(InputInterfaceEntry entry);

    abstract public void undo();

    abstract public void redo();

    abstract public void saveState();

}
