/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/24, 11:40
!  AUTHOR(S): KOGA, Junichiro
!  File : ChartCreator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.graph.chart;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeriesCollection;

import ciss.phase_viewer.graph.dataset.DataSetCollection;
import ciss.phase_viewer.graph.dataset.DataSetElement;
import ciss.phase_viewer.graph.dataset.PlotProperties;
import ciss.phase_viewer.graph.dataset.SubPlotProperties;

/**
 * chart쐬X.
 * 
 * @author
 */
public class ChartCreator {
    private Logger logger = Logger.getLogger(ChartCreator.class.getName());

    /**
     * Creates a new instance of ChartCreator
     */
    public ChartCreator() {
    }

    public JFreeChart getChart(PlotProperties properties) {
        if (properties == null) {
            logger.error("invalid plotproperties.");
            return null;
        }

        if (properties.getPlotType() == PlotProperties.XYPLOT) {
            return createXYPlot(properties);
        } else if (properties.getPlotType() == PlotProperties.PIEPLOT) {
            return createPieChart(properties);
        }

        return null;
    }

    private JFreeChart createPieChart(PlotProperties properties) {
        SubPlotProperties[] spp = properties.getSubPlotProperties();
        if (spp == null || spp.length == 0) {
            return null;
        }
        JFreeChart chart = ChartFactory.createPieChart(properties.getTitle(),
                spp[0].getDataSetCollection().getPieDataset(0), false, true,
                false);
        return chart;
    }

    private JFreeChart createXYPlot(PlotProperties properties) {
        SubPlotProperties[] spp = properties.getSubPlotProperties();
        if (spp == null || spp.length == 0) {
            logger.error("invalid subplot properties");
            return null;
        }

        XYPlot[] xyplots = new XYPlot[spp.length];
        DataSetElement domain = spp[0].getDataSetCollection().getDomain();
        DataSetElement[] range = spp[0].getDataSetCollection().getRange();

        for (int i = 0; i < spp.length; i++) {
            xyplots[i] = getXYPlotFrom(spp[i]);
        }

        if (xyplots == null || xyplots.length == 0 || xyplots[0] == null) {
            logger.error("failed to create xy-plot.");
            return null;
        }

        int orientation = properties.getPlotOrientation();
        double gap = properties.getGap();
        JFreeChart chart = null;
        if (orientation == PlotProperties.DOMAIN) {
            NumberAxis nax = new NumberAxis(domain.getFullName());
            nax.setAutoRangeIncludesZero(false);
            nax.setAutoRange(true);
            CombinedDomainXYPlot pl = new CombinedDomainXYPlot(nax);
            pl.setGap(gap);
            pl.setOrientation(PlotOrientation.VERTICAL);
            for (int i = 0; i < xyplots.length; i++) {
                pl.add(xyplots[i], spp[i].getWeight());
            }
            chart = new JFreeChart(properties.getTitle(),
                    JFreeChart.DEFAULT_TITLE_FONT, pl, false);
        } else if (orientation == PlotProperties.RANGE) {
            String aname = range[0].getFullName();
            for (int i = 1; i < range.length; i++) {
                aname += ", " + range[i].getFullName();
            }
            NumberAxis nay = new NumberAxis(range[0].getFullName());
            nay.setAutoRangeIncludesZero(false);
            nay.setAutoRange(true);
            CombinedRangeXYPlot pl = new CombinedRangeXYPlot(nay);
            pl.setGap(gap);
            pl.setOrientation(PlotOrientation.VERTICAL);
            for (int i = 0; i < xyplots.length; i++) {
                pl.add(xyplots[i], spp[i].getWeight());
            }
            chart = new JFreeChart(properties.getTitle(),
                    JFreeChart.DEFAULT_TITLE_FONT, pl, true);
        } else {
            logger.error("invalid plot orientation");
        }

        return chart;
    }

    private XYPlot getXYPlotFrom(SubPlotProperties spp) {
        DataSetCollection collection = spp.getDataSetCollection();
        XYPlot pl = null;
        int paintCount = 0;
        StandardXYItemRenderer renderer0 = null;
        int multiple_type = spp.getMultipleAxisType();

        for (int i = 0; i < collection.getDataSetCollectionCount(); i++) {
            DataSetElement[] dse = collection.getRange(i);
            DataSetElement dsedomain = collection.getDomain(i);
            String axisName = "";
            if (dse != null && dse.length != 0) {
                axisName = dse[0].getFullName();
                for (int j = 1; j < dse.length; j++) {
                    axisName += ", " + dse[j].getFullName();
                }
            }

            XYSeriesCollection xyseries = collection.getXYSeriesCollection(i);
            if (xyseries == null) {
                logger.debug("xyseries were null");
                return null;
            }
            NumberAxis rax = new NumberAxis(axisName);
            rax.setAutoRangeIncludesZero(false);
            StandardXYItemRenderer renderer = new StandardXYItemRenderer();
            if (i == 0) {
                NumberAxis dax = new NumberAxis("");
                dax.setAutoRangeIncludesZero(false);
                pl = new XYPlot(xyseries, dax, rax, renderer);
                renderer0 = renderer;
            } else {
                if (multiple_type == SubPlotProperties.MULTIPLE_AXIS_Y) {
                    pl.setRangeAxis(i, rax);
                    if (i % 2 == 0) {
                        pl.setRangeAxisLocation(i, AxisLocation.BOTTOM_OR_LEFT);
                    } else {
                        pl.setRangeAxisLocation(i, AxisLocation.BOTTOM_OR_RIGHT);
                    }
                    pl.mapDatasetToRangeAxis(i, i);
                    pl.setDataset(i, xyseries);
                } else if (multiple_type == SubPlotProperties.MULTIPLE_AXIS_X) {
                    NumberAxis ax = new NumberAxis(dsedomain.getFullName());
                    pl.setDomainAxis(i, ax);
                    if (i % 2 == 0) {
                        pl.setDomainAxisLocation(i, AxisLocation.BOTTOM_OR_LEFT);
                    } else {
                        pl.setDomainAxisLocation(i, AxisLocation.TOP_OR_LEFT);
                    }
                    pl.mapDatasetToDomainAxis(i, i);
                    pl.setDataset(i, xyseries);
                }
            }

            for (int j = 0; j < xyseries.getSeriesCount(); j++) {
                renderer.setSeriesPaint(j,
                        renderer0.getSeriesPaint(paintCount + j));
            }
            pl.setRenderer(i, renderer);
            paintCount += xyseries.getSeriesCount();
        }
        return pl;

    }

}
