/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : SimpleGUI.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import ciss.phase_viewer.mainpanel.InternalFrameChase;

//public abstract class SimpleGUI extends JFrame {
//public abstract class SimpleGUI extends FrameChase {
public abstract class SimpleGUI extends InternalFrameChase {
    protected DecimalFormat formater = ConstParameters.formater;

    private boolean disposeAfterAction = false;

    private String button1String = "OK";
    private String button2String = "Close";

    protected JPanel pbutton;

    protected JButton btnok;

    /**
     * GUI̐`쐬
     */
    public SimpleGUI(String title) {
        super(title, true, true, true, true);
        create();
    }

    public SimpleGUI(String title, boolean disposeAfterAction) {
        super(title, true, true, true, true);
        this.disposeAfterAction = disposeAfterAction;
        this.create();
    }

    public SimpleGUI(String title, String button1String, String button2String) {
        super(title, true, true, true, true);
        this.button1String = button1String;
        this.button2String = button2String;
        this.create();
    }

    public SimpleGUI(String title, boolean disposeAfterAction,
            String button1String, String button2String) {
        super(title, true, true, true, true);
        this.disposeAfterAction = disposeAfterAction;
        this.button1String = button1String;
        this.button2String = button2String;
        this.create();
    }

    public SimpleGUI(String title, Dimension size) {
        super(title, true, true, true, true, size);
        create();
    }

    public SimpleGUI(String title, boolean disposeAfterAction, Dimension size) {
        super(title, true, true, true, true, size);
        this.disposeAfterAction = disposeAfterAction;
        this.create();
    }

    public SimpleGUI(String title, String button1String, String button2String,
            Dimension size) {
        super(title, true, true, true, true, size);
        this.button1String = button1String;
        this.button2String = button2String;
        this.create();
    }

    public SimpleGUI(String title, boolean disposeAfterAction,
            String button1String, String button2String, Dimension size) {
        super(title, true, true, true, true, size);
        this.disposeAfterAction = disposeAfterAction;
        this.button1String = button1String;
        this.button2String = button2String;
        this.create();
    }

    public SimpleGUI(String title, int mode, Dimension size) {
        super(title, true, true, true, true, size, mode);
        create();
    }

    public SimpleGUI(String title, boolean disposeAfterAction, int mode,
            Dimension size) {
        super(title, true, true, true, true, size, mode);
        this.disposeAfterAction = disposeAfterAction;
        this.create();
    }

    public SimpleGUI(String title, String button1String, String button2String,
            int mode, Dimension size) {
        super(title, true, true, true, true, size, mode);
        this.button1String = button1String;
        this.button2String = button2String;
        this.create();
    }

    public SimpleGUI(String title, boolean disposeAfterAction,
            String button1String, String button2String, int mode, Dimension size) {
        super(title, true, true, true, true, size, mode);
        this.disposeAfterAction = disposeAfterAction;
        this.button1String = button1String;
        this.button2String = button2String;
        this.create();
    }

    public SimpleGUI(String title, int mode, Dimension size, boolean init) {
        super(title, true, true, true, true, size, mode, init);
        this.button1String = button1String;
        this.button2String = button2String;
        this.create();
    }

    private void create() {
        Container cont = getContentPane();
        cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));
        cont.add(createMainPanel());
        cont.add(createButtonPanel());
    }

    /** create the button Panel */
    private JPanel createButtonPanel() {
        pbutton = new JPanel();
        pbutton.setLayout(new FlowLayout());
        btnok = new JButton(button1String);
        JButton btncancel = new JButton(button2String);
        pbutton.add(btnok);
        pbutton.add(btncancel);

        btnok.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                action();
                if (disposeAfterAction) {
                    dispose();
                }
            }
        });

        btncancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                destructor();
                dispose();
            }
        });
        return pbutton;
    }

    /** set action for the "OK" button */
    protected abstract boolean action();

    /** create body of the GUI */
    protected abstract JPanel createMainPanel();

    protected void destructor() {
    }

    protected void addButtons(JButton button) {
        pbutton.add(button);
    }

    protected void addButtons(JButton button, int pos) {
        pbutton.add(button, pos);
    }

}
