/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ConstParameters.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.text.DecimalFormat;

public class ConstParameters {

    // for elements
    public static int MAX_ELEMENTS = 150 /* !< f̏ */;
    public static int NOSUCHELEMENT = -1 /* !< ݂Ȃfw肵ۂɕԂintl */;

    // for units
    public static int UNIT_LIST_SIZE = 3; /* !< uPʎv̐ */
    public static String TYP_ENERGY = "energy";
    public static String TYP_LEN = "length";
    public static double AMU = 1822.87733; /* !< ʂ̌qP */
    public static final double RAD_TO_ANG = 180.d / Math.PI; /* !< WAx֕ϊ */
    public static final double ANG_TO_RAD = Math.PI / 180.d; /* !< x烉WA֕ϊ */

    // public static final double BOHR_2_ANG = 0.529177d;
    public static final double BOHR_2_ANG = 0.5291772480d;
    public static double ANG_2_BOHR = 1.d / BOHR_2_ANG;

    // for PP prefs
    public static int MAX_PP = 20;

    // typical strings for log file
    public static String CONST_CHECK = "consistency check ... ";
    public static String OK = " OK ";
    public static String ERR = " ERROR ";
    public static String WAR = " WARNING ";
    public static String CR = System.getProperty("line.separator")/* !< OS̍s؂ */;
    public static String FS = System.getProperty("file.separator")/*
                                                                   * !<
                                                                   * OS̃t@C؂
                                                                   */;

    public static String osName = System.getProperty("os.name")/* !< os */;

    // Default file names for phase
    public static final String DEFAULT_F_INP = "nfinp.data" /*
                                                             * !< file_names.
                                                             * datat@C̃ftHgGg[
                                                             */;
    public static final String DEFAULT_F_KPOINT = "kpoint.data" /*
                                                                 * !<
                                                                 * file_names.
                                                                 * datat@C̃ftHgGg[
                                                                 */;
    public static final String DEFAULT_F_DYNM = "nfdynm.data" /*
                                                               * !< file_names.
                                                               * datat@C̃ftHgGg[
                                                               */;
    public static final String DEFAULT_F_ENF = "nfene.data" /*
                                                             * !< file_names.
                                                             * datat@C̃ftHgGg[
                                                             */;
    // public static final String DEFAULT_F_CHR = "nfchr.data";
    public static final String DEFAULT_F_CHR = "nfchr.cube" /*
                                                             * !< file_names.
                                                             * datat@C̃ftHgGg[
                                                             */;
    public static final String DEFAULT_F_DOS = "dos.data" /*
                                                           * !< file_names.
                                                           * datat@C̃ftHgGg[
                                                           */;
    public static final String DEFAULT_F_ENERG = "nfenergy.data" /*
                                                                  * !<
                                                                  * file_names.
                                                                  * datat@C̃ftHgGg[
                                                                  */;
    public static final String DEFAULT_F_ZAJ = "nfzaj.data" /*
                                                             * !< file_names.
                                                             * datat@C̃ftHgGg[
                                                             */;
    public static final String DEFAULT_F_CHGT = "nfchgt.data" /*
                                                               * !< file_names.
                                                               * datat@C̃ftHgGg[
                                                               */;
    public static final String DEFAULT_F_CNTN = "continue.data" /*
                                                                 * !<
                                                                 * file_names.
                                                                 * datat@C̃ftHgGg[
                                                                 */;
    public static final String DEFAULT_F_CNTN_BIN = "continue_bin.data" /*
                                                                         * !<
                                                                         * file_names
                                                                         * .
                                                                         * datat@C̃ftHgGg[
                                                                         */;
    public static final String DEFAULT_OUTPUT = "output000" /*
                                                             * !< file_names.
                                                             * datat@C̃ftHgGg[
                                                             */;

    public static final String APPLY_TO_ALL = "apply to all" /*
                                                              * !< , ``apply
                                                              * to all''
                                                              */;
    public static final String[] COLNAME_ATOM = { "No.", "element", "rx", "ry",
            "rz", "mobile", "weight" } /* !< qzue[ũJ */;

    public static final String[] ZERO_OR_ONE = { "0", "1" }; /* !< 01. */
    public static final String[] ONE_OR_TWO = { "1", "2" }; /* !< 12. */
    public static final String[] NULL_OR_ZERO_OR_ONE = { "", "0", "1" };/*
                                                                         * !<k01
                                                                         */
    public static final String[] NULL_OR_ONE_OR_TWO = { "", "1", "2" };/*
                                                                        * !<k12
                                                                        */

    public static final DecimalFormat formater = new DecimalFormat(
            "0.00########"); /* !<_tH[}b^[ */
    public static final DecimalFormat formater_float = new DecimalFormat(
            "0.00########");
    public static final DecimalFormat formater_smaller_digits = new DecimalFormat(
            "0.00##"); /* !<_tH[}b^[ */

    public static String NO_SELECTION = "---------";

    private ConstParameters() {
        // prevent instantiation
        // static methods & parameters only!!
    }

    public static String getJavaPath() {
        String javaPath = System.getProperty("java.home") + FS + "bin" + FS
                + "java";

        if (System.getProperty("os.name").trim().startsWith("windows")) {
            javaPath += ".exe";
        }

        return javaPath;
    }

}
