/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : AxisObject.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import java.awt.Font;

import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CylinderCreator;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;

import com.sun.j3d.utils.geometry.Text2D;

class AxisObject extends SceneGraphElement implements PropertiesListener {
    private static Logger logger = Logger.getLogger(AxisObject.class.getName());
    private GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);
    private double length = 0.1f;
    private int fontSize = 18;
    private Color3f fontColor = new Color3f(new float[] { 0, 0, 0 });
    private Vector3f pos = new Vector3f(-0.8f, -0.7f, 0f);

    public AxisObject() {
        super();
        props.addPropertiesListener(this);
        readProps();
    }

    private void readProps() {
        try {
            length = Double.parseDouble(props.getProperty("axis_length"));
            fontSize = Integer.parseInt(props
                    .getProperty("axis_label_font_size"));
            String[] sfontColor = props.getProperty("axis_label_font_color")
                    .split(",");
            fontColor = new Color3f(new float[] {
                    Float.parseFloat(sfontColor[0]),
                    Float.parseFloat(sfontColor[1]),
                    Float.parseFloat(sfontColor[2]) });
            String[] spos = props.getProperty("axis_pos").split(",");
            pos = new Vector3f(Float.parseFloat(spos[0]),
                    Float.parseFloat(spos[1]), Float.parseFloat(spos[2]));
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public int getType() {
        return SceneGraphElement.AXIS;
    }

    private BranchGroup rootBranch;

    public void create() {
        rootBranch = new BranchGroup();
        rootBranch.setCapability(BranchGroup.ALLOW_DETACH);

        CylinderCreator cylindercreate = new CylinderCreator();
        BranchGroup XAxis = new BranchGroup();
        BranchGroup YAxis = new BranchGroup();
        BranchGroup ZAxis = new BranchGroup();
        cylindercreate.setResolution(30);

        Appearance textAppear;
        PolygonAttributes polyAttrib;

        Transform3D rotatex = new Transform3D();
        Transform3D rotatey = new Transform3D();
        Transform3D rotatez = new Transform3D();

        rotatex.rotZ(-Math.PI / 2.0d);
        rotatey.rotY(0.0d);
        rotatez.rotX(Math.PI / 2.0d);

        XAxis = cylindercreate.create(new Point3d(0.0d, 0.0d, 0.0d),
                new Point3d(length, 0.0d, 0.0d), 0.005d, 0.02f, 0.04f);
        YAxis = cylindercreate.create(new Point3d(0.0d, 0.0d, 0.0d),
                new Point3d(0.0d, length, 0.0d), 0.005d, 0.02f, 0.04f);
        ZAxis = cylindercreate.create(new Point3d(0.0d, 0.0d, 0.0d),
                new Point3d(0.0d, 0.0d, length), 0.005d, 0.02f, 0.04f);

        Transform3D translatex = new Transform3D();
        Transform3D translatey = new Transform3D();
        Transform3D translatez = new Transform3D();
        Transform3D translateorigin = new Transform3D();

        translatex.set(new Vector3f((float) length, 0.0f, 0.0f));
        translatey.set(new Vector3f(0.0f, (float) length, 0.0f));
        translatez.set(new Vector3f(0.0f, 0.0f, (float) length));

        // translateorigin.set(new Vector3f(-0.8f, -0.7f, 0.0f));
        translateorigin.set(pos);

        translatex.setScale(1.0f);
        translatey.setScale(1.0f);
        translatez.setScale(1.0f);

        TransformGroup tfgx = new TransformGroup(translatex);
        TransformGroup tfgy = new TransformGroup(translatey);
        TransformGroup tfgz = new TransformGroup(translatez);

        TransformGroup tfgxc = new TransformGroup();
        TransformGroup tfgyc = new TransformGroup();
        TransformGroup tfgzc = new TransformGroup();

        tfgxc.setTransform(rotatex);
        tfgyc.setTransform(rotatey);
        tfgzc.setTransform(rotatez);

        TransformGroup tfgxc2 = new TransformGroup(translatex);
        TransformGroup tfgyc2 = new TransformGroup(translatey);
        TransformGroup tfgzc2 = new TransformGroup(translatez);

        tfgxc2.addChild(tfgxc);
        tfgyc2.addChild(tfgyc);
        tfgzc2.addChild(tfgzc);

        Font3D font = new Font3D(new Font("TimesRoman", Font.ITALIC, 1),
                new FontExtrusion());

        Color3f color_wkl2 = fontColor;
        Text2D xtext = new CapableText2D(" x", color_wkl2, "TimesRoman",
                fontSize, Font.ITALIC);
        Text2D ytext = new CapableText2D(" y", color_wkl2, "TimesRoman",
                fontSize, Font.ITALIC);
        Text2D ztext = new CapableText2D(" z", color_wkl2, "TimesRoman",
                fontSize, Font.ITALIC);

        Point3f lp3f = new Point3f(0.0f, 0.0f, 0.0f);
        OrientedShape3D xtextShape = new OrientedShape3D(xtext.getGeometry(),
                xtext.getAppearance(), OrientedShape3D.ROTATE_ABOUT_POINT, lp3f);
        OrientedShape3D ytextShape = new OrientedShape3D(ytext.getGeometry(),
                ytext.getAppearance(), OrientedShape3D.ROTATE_ABOUT_POINT, lp3f);
        OrientedShape3D ztextShape = new OrientedShape3D(ztext.getGeometry(),
                ztext.getAppearance(), OrientedShape3D.ROTATE_ABOUT_POINT, lp3f);

        tfgx.addChild(xtextShape);
        tfgy.addChild(ytextShape);
        tfgz.addChild(ztextShape);

        rootBranch.addChild(XAxis);
        rootBranch.addChild(YAxis);
        rootBranch.addChild(ZAxis);
        rootBranch.addChild(tfgx);
        rootBranch.addChild(tfgy);
        rootBranch.addChild(tfgz);

        this.addChild(rootBranch);
    }

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
    }

    public void propertiesStored(GlobalProperties properties) {
        readProps();
        rootBranch.detach();
        create();
    }

}
