/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/08, 14:46
!  AUTHOR(S): KOGA, Junichiro
!  File : BoundPlane.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.geom;

import java.util.Vector;

import javax.vecmath.Point3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.VectorOperations;

/**
 * L̖ʂ\. L̖ʂɂ, Cӂ̐_. ܂, _ƕł΂̔z񂩂ӂ.
 * 
 * @author
 */
public class BoundPlane extends Plane {
    private Logger logger = Logger.getLogger(BoundPlane.class.getName());

    private Vector vertices = new Vector(); /* _i[Vector */

    float verySmall = 0.0001f;

    /**
     * ftHglŏ. _: 0,0,0 @xNg: 0,0,1
     */
    public BoundPlane() {
        super();
    }

    /**
     * @xNg^ď. ꉞ, KiĂ邱Ƃz.
     * 
     * @param normal
     *            @xNg
     */
    public BoundPlane(Point3f normal) {
        super(normal);
    }

    /**
     * @xNg_^ď.
     * 
     * @param normal
     *            @xNg
     * @param origin
     *            _
     */
    public BoundPlane(Point3f normal, Point3f origin) {
        super(normal, origin);
    }

    /**
     * _Zbg(̃\bhŃZbgꍇ, _obt@[͏!!) , \[gs.
     * 
     * @param _z
     */
    public void setVertices(Point3f[] points) {
        vertices = new Vector();
        for (int i = 0; i < points.length; i++) {
            vertices.addElement(points[i]);
        }
        sortVertices();
    }

    /**
     * _Oȏ゠Ƃ͖@xNg쐬. łȂΉȂ.
     */
    public void generateNormal() {
        if (vertices.size() < 3) {
            return;
        }
        Point3f p1 = (Point3f) vertices.get(0);
        Point3f p2 = (Point3f) vertices.get(1);
        Point3f p3 = (Point3f) vertices.get(2);
        Point3f ref1 = new Point3f();
        Point3f ref2 = new Point3f();
        ref1.add(p1);
        ref1.sub(p2);
        ref2.add(p3);
        ref2.sub(p2);
        float[] norm = VectorOperations.getNormalVector(new float[] { ref1.x,
                ref1.y, ref1.z }, new float[] { ref2.x, ref2.y, ref2.z });
        setNormalVector(new Point3f(norm));
    }

    /**
     * uʂ̌_v̍쐬
     */
    public void generateOrigin() {
        if (vertices.size() == 0) {
            // logger.error("no vertices.");
            return;
        }
        setOrigin(new Point3f((Point3f) vertices.get(0)));
        //
        // Point3f sum = new Point3f();
        // for ( int i=0 ; i<vertices.size() ; i++ ) {
        // sum.x += ((Point3f) vertices.get(i)).x;
        // sum.y += ((Point3f) vertices.get(i)).y;
        // sum.z += ((Point3f) vertices.get(i)).z;
        // }
        // sum.x /= vertices.size();
        // sum.y /= vertices.size();
        // sum.z /= vertices.size();
        //
        // origin = new Point3f(sum);
    }

    /**
     * _𑫂. dđƂ͂Ȃ.
     * 
     * @param vertex
     *            _
     */
    public void addVertex(Point3f vertex) {
        for (int i = 0; i < vertices.size(); i++) {
            Point3f tmp = (Point3f) vertices.get(i);
            if (tmp.epsilonEquals(vertex, verySmall)) {
                return;
            }
        }
        vertices.addElement(vertex);
    }

    /**
     * _ւ
     * 
     * @param vertex
     *            ւ钸_
     * @param i
     *            ւꏊ
     */
    public void setVertexAt(Point3f vertex, int i) {
        vertices.setElementAt(vertex, i);
    }

    /**
     * _폜
     * 
     * @param vertex
     *            폜vertex
     */
    public void removeVertex(Point3f vertex) {
        for (int i = 0; i < vertices.size(); i++) {
            Point3f p3f = (Point3f) vertices.get(i);
            if (p3f.epsilonEquals(vertex, verySmall)) {
                vertices.removeElementAt(i);
            }
        }
    }

    /**
     * _ւ. Ȃꍇ, Ōɑ.
     * 
     * @param from
     *            "ւ"
     * @param to
     *            "ւ"
     */
    public void replaceVertex(Point3f from, Point3f to) {
        for (int i = 0; i < vertices.size(); i++) {
            Point3f p3f = (Point3f) vertices.get(i);
            if (p3f.epsilonEquals(from, verySmall)) {
                vertices.set(i, to);
                return;
            }
        }
        vertices.add(to);
    }

    /**
     * _폜
     * 
     * @param i
     *            폜vertexindex
     */
    public void removeVertex(int i) {
        vertices.remove(i);
    }

    /**
     * _擾.
     * 
     * @return _̔z
     */
    public Point3f[] getVertices() {
        Point3f[] ret = new Point3f[vertices.size()];
        vertices.copyInto(ret);
        return ret;
    }

    /**
     * _, "JmjJȏ"ɂȂт. ӂ擾OɈx͌ĂԂ. JmjJȏƂ, vȂv.
     */
    public void sortVertices() {
        if (vertices == null || vertices.size() <= 2) {
            return;
        }
        vertices.trimToSize();
        Point3f[] verts = new Point3f[vertices.size()];
        vertices.copyInto(verts);
        Point3f[] ordered = Sorter.radiallyClockWise(verts);
        if (ordered != null && ordered.length >= 2) {
            for (int i = 0; i < ordered.length; i++) {
                vertices.set(i, ordered[i]);
            }
        } else {
            logger.error("invalid vertices!!");
        }
    }

    /**
     * wSideĂ邩ۂ
     * 
     * @param side
     *            eXg
     * @return sideĂꍇtrue
     */
    public boolean hasSide(Side side) {
        Point3f sp1 = side.getPoint1();
        Point3f sp2 = side.getPoint2();
        for (int i = 0; i < vertices.size() - 1; i++) {
            for (int j = i + 1; j < vertices.size(); j++) {
                Point3f lp1 = (Point3f) vertices.get(i);
                Point3f lp2 = (Point3f) vertices.get(j);

                if ((lp1.epsilonEquals(sp1, verySmall) && lp2.epsilonEquals(
                        sp2, verySmall))
                        || lp2.epsilonEquals(sp1, verySmall)
                        && lp1.epsilonEquals(sp2, verySmall)) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * ̖ʂĂ""̔z擾郁\bh. ̃\bhĂԑO, KsortVertices()ĂԂ. ܂,
     * _̐01̏ꍇnullԂ.
     * 
     * @return ̖ʂĂ""̔z
     */
    public Side[] getSides() {
        if (vertices == null || vertices.size() < 2) {
            return null;
        }
        Vector sides = new Vector();
        for (int i = 0; i < vertices.size(); i++) {
            int i2 = i + 1;
            if (i2 == vertices.size()) {
                i2 = 0;
            }
            Point3f p3f1 = (Point3f) vertices.get(i);
            Point3f p3f2 = (Point3f) vertices.get(i2);
            Side side = new Side(p3f1, p3f2);
            sides.addElement(side);
        }
        Side[] ret = new Side[sides.size()];
        sides.copyInto(ret);

        return ret;
    }

    /**
     * w̃o[ebNX̖ʂɑ݂邩ǂ𔻒
     * 
     * @param v
     *            eXgo[ebNX
     * @return ݂Ȃtrue
     */
    public boolean hasVertex(Point3f v) {
        for (int i = 0; i < vertices.size(); i++) {
            Point3f p = (Point3f) vertices.get(i);
            if (p.epsilonEquals(v, verySmall)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String ret = "";
        ret += "vertices: ";
        for (int i = 0; i < vertices.size(); i++) {
            ret += System.getProperty("line.separator")
                    + vertices.get(i).toString();
        }
        return ret;
    }

}
