/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/14, 16:53
!  AUTHOR(S): KOGA, Junichiro
!  File : SilentMyProgressMonitor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.ssh.sftp;

import ciss.phase_viewer.mainpanel.ChaseProgressMonitor;
import ciss.phase_viewer.mainpanel.ProgressInfo;

import com.jcraft.jsch.SftpProgressMonitor;

/**
 * 
 * @author
 */
public class SilentMyProgressMonitor implements SftpProgressMonitor,
        ProgressInfo {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(SilentMyProgressMonitor.class.getName());
    /** Creates a new instance of SilentMyProgressMonitor */
    private long count = 0;
    private long max = 0;
    private String src;
    private String name;

    public SilentMyProgressMonitor(String name) {
        this.name = name;
    }

    public void init(int op, String src, String dest, long max) {
        this.max = max;
        this.src = src;
        count = 0;
        ChaseProgressMonitor monitor = ChaseProgressMonitor.getMonitor();
        if (monitor != null) {
            monitor.setProgress(this);
        }
    }

    public boolean count(long count) {
        this.count += count;
        if (count == max) {
            isDone = true;
        }
        return !isDone;
    }

    public void end() {
        isDone = true;
        ChaseProgressMonitor.getMonitor().stop();
    }

    private boolean isDone = false;

    public boolean isDone() {
        return isDone;
    }

    public int getLength() {
        return (int) this.max;
    }

    public String getCurrentMessage() {
        return name + "... completed " + this.count + " out of " + max + ".";
    }

    public int getCurrent() {
        return (int) this.count;
    }

    public String getNameOfProgress() {
        return this.name;
    }

    public void done() {
    }

}
