/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : SftpClient.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.ssh.sftp;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.ssh.hosts.HostConfigurator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostSelectorMenu;
import ciss.phase_viewer.ssh.terminal.Terminal;

public class SftpClient extends InternalFrameChase {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(SftpClient.class.getName());
    private SftpClientPanel sftpPanel;

    public SftpClient() {
        super("sftp client", true, true, true, true, new Dimension(700, 500));
        sftpPanel = new SftpClientPanel(true);
        init();
    }

    public SftpClient(HostInfo hostinfo) {
        super("sftp client", true, true, true, true, new Dimension(700, 500));
        sftpPanel = new SftpClientPanel(hostinfo);
        init();
    }

    public SftpClient(HostInfo hostinfo, boolean local_has_proj) {
        super("sftp client", true, true, true, true, new Dimension(700, 500));
        sftpPanel = new SftpClientPanel(hostinfo, local_has_proj);
        init();
    }

    private void init() {
        JPanel p = createBrowsersAndButtons();
        this.getContentPane().setLayout(
                new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
        this.getContentPane().add(p);
        this.setJMenuBar(new SftpClientMenuBar());
        addInternalFrameListener(new InternalFrameListener() {

            public void internalFrameActivated(InternalFrameEvent e) {
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                if (sftpPanel != null)
                    sftpPanel.disconnect();
            }

            public void internalFrameClosing(InternalFrameEvent e) {
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            public void internalFrameIconified(InternalFrameEvent e) {
            }

            public void internalFrameOpened(InternalFrameEvent e) {
            }

        });
        setVisible(true);
    }

    private JPanel createBrowsersAndButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        JPanel buttons = createButtons();
        p.add(sftpPanel);
        p.add(buttons);

        return p;
    }

    private JPanel createButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));

        JButton upload = new JButton("upload");
        JButton download = new JButton("download");
        p.add(upload);
        p.add(download);

        upload.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                sftpPanel.uploadFiles();
            }
        });

        download.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                sftpPanel.downloadFiles();
            }
        });

        JButton close = new JButton("close");
        p.add(close);
        close.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        return p;
    }

    public void dispose() {
        sftpPanel.disconnect();
        super.dispose();
    }

    class SftpClientMenuBar extends JMenuBar {
        SftpClientMenuBar() {
            super();
            createMenu();
        }

        private void createMenu() {
            this.add(fileMenu());
            this.add(new HostSelectorMenu(sftpPanel, "hosts", KeyEvent.VK_H));
            this.add(toolMenu());
        }

        private MyJMenu fileMenu() {
            MyJMenu file = new MyJMenu("File", KeyEvent.VK_F, false);

            MyJMenu local = new MyJMenu("local", KeyEvent.VK_L);
            MyJMenuItem[] localitems = getLocalItems();
            for (int i = 0; i < localitems.length; i++) {
                local.add(localitems[i]);
            }

            MyJMenu remote = new MyJMenu("remote", KeyEvent.VK_R, false);
            MyJMenuItem[] remoteitems = getRemoteItems();
            for (int i = 0; i < remoteitems.length; i++) {
                remote.add(remoteitems[i]);
            }

            MyJMenuItem exit = new MyJMenuItem("exit", KeyEvent.VK_X);

            file.add(local);
            file.add(remote);
            file.add(exit);

            exit.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    dispose();
                }
            });

            return file;
        }

        private MyJMenuItem[] getLocalItems() {
            MyJMenuItem locdel = new MyJMenuItem("delete", KeyEvent.VK_D);
            MyJMenuItem locchfname = new MyJMenuItem("rename", KeyEvent.VK_C);
            MyJMenuItem locmkdir = new MyJMenuItem("create new dir",
                    KeyEvent.VK_N);
            MyJMenuItem locprops = new MyJMenuItem("property", KeyEvent.VK_P);
            MyJMenuItem[] ret = { locchfname, locmkdir, locprops, locdel };

            locdel.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sftpPanel.getBrowserTree(SftpClientPanel.LOCAL_PANE)
                            .deleteSelectedFiles();
                }
            });

            locchfname.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sftpPanel.getBrowserTree(SftpClientPanel.LOCAL_PANE)
                            .rename();
                }
            });

            locmkdir.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sftpPanel.getBrowserTree(SftpClientPanel.LOCAL_PANE)
                            .mkdir();
                }
            });

            locprops.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sftpPanel.getBrowserTree(SftpClientPanel.LOCAL_PANE)
                            .bootFilePropertyViewer();
                }
            });

            return ret;
        }

        private MyJMenuItem[] getRemoteItems() {
            MyJMenuItem remdel = new MyJMenuItem("delete", KeyEvent.VK_D);
            MyJMenuItem remchfname = new MyJMenuItem("rename", KeyEvent.VK_C);
            MyJMenuItem remmkdir = new MyJMenuItem("create new dir",
                    KeyEvent.VK_N);
            MyJMenuItem remprops = new MyJMenuItem("property", KeyEvent.VK_P);
            MyJMenuItem[] ret = { remchfname, remmkdir, remprops, remdel };
            remdel.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sftpPanel.getBrowserTree(SftpClientPanel.REMOTE_PANE)
                            .deleteSelectedFiles();
                }
            });

            remchfname.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sftpPanel.getBrowserTree(SftpClientPanel.REMOTE_PANE)
                            .rename();
                }
            });

            remmkdir.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sftpPanel.getBrowserTree(SftpClientPanel.REMOTE_PANE)
                            .mkdir();
                }
            });

            remprops.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    sftpPanel.getBrowserTree(SftpClientPanel.REMOTE_PANE)
                            .bootFilePropertyViewer();
                }
            });

            return ret;
        }

        private MyJMenu toolMenu() {
            MyJMenu tool = new MyJMenu("Tools", KeyEvent.VK_C, false);
            MyJMenuItem host = new MyJMenuItem("host configurator",
                    KeyEvent.VK_H);
            MyJMenuItem term = new MyJMenuItem("terminal", KeyEvent.VK_P);
            tool.add(host);
            tool.add(term);

            host.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    HostConfigurator configurator = new HostConfigurator();
                }
            });

            term.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    Terminal te = new Terminal(sftpPanel.getHostInfo());
                }
            });

            return tool;
        }

    }

}
