/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/19, 16:17
!  AUTHOR(S): KOGA, Junichiro
!  File : ScriptDescriptionPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.scripting;

import java.awt.Dimension;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

/**
 * ƂXNvǵuv\.
 * 
 * @author
 */
public class ScriptDescriptionPanel extends JPanel {
    private Logger logger = Logger.getLogger(ScriptDescriptionPanel.class
            .getName());
    private JTextPane textPane;

    /**
     * @param scriptFile
     *            XNvgt@Cւ̃pX
     */
    public ScriptDescriptionPanel(String scriptFile) {
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        setBorder(new TitledBorder("description"));
        textPane = new JTextPane();
        textPane.setContentType("text;charset=Shift_JIS");
        textPane.setEditable(false);
        textPane.setText(ScriptUtils.getDescriptionFrom(scriptFile));
        JScrollPane scr = new JScrollPane(textPane);
        scr.setPreferredSize(new Dimension(500, 300));
        add(scr);
        textPane.setCaretPosition(0);
        revalidate();
    }

    /**
     * 
     */
    public ScriptDescriptionPanel() {
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        setBorder(new TitledBorder("description"));
        textPane = new JTextPane();
        textPane.setContentType("text;charset=Shift_JIS");
        textPane.setEditable(false);
        JScrollPane scr = new JScrollPane(textPane);
        add(scr);
    }

    /**
     * GUI͏\ړIƂĂ邽߃ftHgł͕ҏWsɂĂ邪, ̃\bh𗘗pΕҏWɂł.
     * 
     * @param editable
     *            truenΕҏWƂȂ.
     */
    public void setEditable(boolean editable) {
        textPane.setEditable(editable);
    }

    /**
     * XNvgt@CZbg. ̃XNvgt@C, \ȏꍇ擾\.
     * 
     * @param scriptFile
     *            XNvgt@Cւ̃pX.
     */
    public void setScriptFile(String scriptFile) {
        textPane.setText(ScriptUtils.getDescriptionFrom(scriptFile));
        textPane.setCaretPosition(0);
        revalidate();
    }

    /**
     * uScript̐pvԂ.
     * 
     * @return Scriptp.
     */
    public String getScriptDescriptionText() {
        return textPane.getText();
    }

}
