/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 17:02
!  AUTHOR(S): KOGA, Junichiro
!  File : FileListPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.sftp.SftpClientPanel;

/**
 * 
 * @author KOGA, Junichiro
 */
public class FileListPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(FileListPanel.class.getName());
    private SftpClientPanel sftpPanel;
    private HostInfo info;

    /** Creates a new instance of FileListPanel */
    public FileListPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void init() {
        removeAll();
        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        sftpPanel = new SftpClientPanel(projectInfo.getProjectDirectory(),
                false);
        add(sftpPanel);

        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, BoxLayout.X_AXIS));
        JButton btnconnect = new JButton("connect");
        JButton btndisconnect = new JButton("disconnect");
        info = projectInfo.getHostInfo();
        JLabel label = new JLabel("target host: " + info.getName() + ", "
                + " target dir: " + projectInfo.getTargetDirectory());
        JPanel plabel = new JPanel();
        plabel.add(label);
        p.add(plabel);
        btnpanel.add(btnconnect);
        btnpanel.add(btndisconnect);
        p.add(btnpanel);
        boolean isLocal = info.isLocalHost();
        btnconnect.setEnabled(!isLocal);
        btndisconnect.setEnabled(!isLocal);
        add(p);

        btnconnect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                sftpPanel.setRemoteInitialDir(projectInfo.getTargetDirectory());
                sftpPanel.connect(info);
            }
        });

        btndisconnect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                sftpPanel.disconnect();
                init();
            }
        });

    }

    public boolean postProcess() {
        if (sftpPanel != null)
            sftpPanel.disconnect();
        return true;
    }

    public void initializeProject() {
    }

}
