/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/13, 21:16
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectDirBrowserObject.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import java.net.URL;
import java.util.List;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class ProjectDirBrowserObject {
    private Logger logger = Logger.getLogger(ProjectDirBrowserObject.class
            .getName());
    private String text;
    private Icon icon;
    private Icon icon_open;
    private ProjectInfo proj;

    /** Creates a new instance of ProjectDirBrowserObject */
    public ProjectDirBrowserObject(ProjectInfo proj) {
        this.proj = proj;
        init();
    }

    private void init() {
        String type = proj.getProjectType();
        URL projurl = ProjectDirBrowserObject.class
                .getResource(ProjectManipulator.PROJECT_MANIPULATOR_XML_PATH);
        Document doc = XMLUtils.getDocumentFromURL(projurl);

        try {
            Element elem = doc.getRootElement();
            if (!elem.getName().equals("root")) {
                logger.error("invalid ProjectSpecification file.");
            }

            List list = elem.getChildren("project");
            String iconpath = null;
            String iconpath_open = null;
            for (int i = 0; i < list.size(); i++) {
                Element element = (Element) list.get(i);
                String name = MyElement
                        .decode(element.getChildTextTrim("name"));
                if (name.equals(type)) {
                    iconpath = MyElement.decode(element
                            .getChildTextTrim("iconpath"));
                    iconpath_open = MyElement.decode(element
                            .getChildTextTrim("iconpath_open"));
                    break;
                }
            }

            logger.debug("iconpath: " + iconpath + " iconpath_open: "
                    + iconpath_open);

            text = proj.getProjectName();
            PluginLoader loader = new PluginLoader();
            URL res = null;
            URL res_open = null;
            try {
                res = loader.getResource(iconpath);
                res_open = loader.getResource(iconpath_open);
            } catch (Exception ex) {
                logger.error("failed to resolve icon path.");
            }
            icon = new ImageIcon(res);
            icon_open = new ImageIcon(res_open);
        } catch (Exception ex) {
            logger.error("error in loading plugin.");
        }
    }

    public void recreate() {
        init();
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Icon getIcon() {
        return (Icon) this.icon;
    }

    public Icon getOpenIcon() {
        return (Icon) this.icon_open;
    }

    public String toString() {
        return this.text;
    }

}
