/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/14, 18:19
!  AUTHOR(S): KOGA, Junichiro
!  File : TransparencySelector.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.apache.log4j.Logger;

/**
 * JSliderJTextField琬, transparencyݒ肷GUI. ,
 * 0100̊Ԃ̐IړIȂȂɂłg.
 * 
 * @author
 */
public class TransparencySelector extends JPanel {
    private Logger logger = Logger.getLogger(TransparencySelector.class
            .getName());

    /** Creates a new instance of TransparencySelector */
    public TransparencySelector(String title) {
        setBorder(new TitledBorder(title));
        init();
    }

    public TransparencySelector() {
        setBorder(new TitledBorder("transparency"));
        init();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        textTrans.setEnabled(b);
        transparencySlider.setEnabled(b);
    }

    private JTextField textTrans;
    private JSlider transparencySlider;

    public void addChangeListener(ChangeListener cl) {
        if (transparencySlider != null)
            transparencySlider.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        if (transparencySlider != null)
            transparencySlider.removeChangeListener(cl);
    }

    private void init() {
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        textTrans = new JTextField(5);
        textTrans.setText("0");
        JPanel ptexttrans = new JPanel();
        ptexttrans.setBorder(new TitledBorder("val"));
        ptexttrans.add(textTrans);
        transparencySlider = new JSlider(0, 100, 0);
        add(ptexttrans);
        add(transparencySlider);

        transparencySlider.setMajorTickSpacing(25);
        transparencySlider.setMinorTickSpacing(10);
        transparencySlider.setPaintTicks(true);
        transparencySlider.setPaintLabels(true);

        transparencySlider.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                CaretListener[] listeners = textTrans.getCaretListeners();
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; i++) {
                        textTrans.removeCaretListener(listeners[i]);
                    }
                }
                textTrans.setText(String.valueOf(transparencySlider.getValue()));
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; i++) {
                        textTrans.addCaretListener(listeners[i]);
                    }
                }
            }
        });

        textTrans.addCaretListener(new CaretListener() {
            public void caretUpdate(CaretEvent ce) {
                ChangeListener[] listeners = transparencySlider
                        .getChangeListeners();
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; i++) {
                        transparencySlider.removeChangeListener(listeners[i]);
                    }
                }
                try {
                    int val = Integer.parseInt(textTrans.getText().trim());
                    transparencySlider.setValue(val);
                } catch (Exception exc) {
                }
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; i++) {
                        transparencySlider.addChangeListener(listeners[i]);
                    }
                }
            }
        });
    }

    /**
     * transparencyZbg
     * 
     * @param transparency
     *            Zbgtransparency̒l
     */
    public void setTransparency(float trans) {
        if (trans > 1) {
            trans = 1;
        }
        if (trans < 0) {
            trans = 0;
        }
        textTrans.setText(String.valueOf((int) (trans * 100f)));
    }

    /**
     * transparency擾; 0-1000-1ɂĕԂ
     * 
     * @return transparency̒l
     */
    public float getTransparency() {
        float trans = 0.f;
        try {
            trans = ((float) Integer.parseInt(textTrans.getText().trim())) / 100.f;
        } catch (Exception exc) {
        }
        if (trans > 1) {
            trans = 1;
        } else if (trans < 0) {
            trans = 0;
        }
        return trans;
    }

}
