/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 11:34
!  AUTHOR(S): KOGA, Junichiro
!  File : ComboBoxPhaseUnit.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import java.awt.event.ActionListener;
import java.util.EventObject;

import javax.swing.JComboBox;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;

/**
 * 
 * @author KOGA, Junichiro
 */
public class ComboBoxPhaseUnit extends JComboBox implements Command,
        InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger(ComboBoxPhaseUnit.class
            .getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;

    private String[] choices;
    private int unitType;
    private boolean writeAll = true;

    public static final int LONGTIME = 1; /*
                                           * !< PHASEvO̎sԂw肷邽߂̒P(day,
                                           * hour,...)w肷.
                                           */
    public static final int TIME = 2; /* !< PHASE̎ (au_time, fs, ... ). */
    public static final int LENGTH = 3; /* !< ̒Pʂw. */
    public static final int ENERGY = 4; /* !< GlM[̒Pʂw. */
    public static final int FORCE = 5; /* !< ͂̒Pʂw. */

    public ComboBoxPhaseUnit(String[] choices, String[] inputSpecifications,
            InputInterface inputinterface, int unitType) {
        super(choices);
        this.choices = choices;
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.unitType = unitType;
        inputinterface.addInputInterfaceEntryChangeListener(this);
    }

    public void execute(EventObject e) {
        inputinterface.selectRoot();
        logger.debug(super.getSelectedItem());
        int inpSpecLength = 1;
        if (writeAll) {
            inpSpecLength = inputSpecifications.length;
        }

        for (int is = 0; is < inpSpecLength; is++) {
            String inp = inputSpecifications[is];
            InputInterfaceUnits units = inputinterface
                    .getInputInterfaceUnits(inp);
            units.saveState();
            String newText = (String) super.getSelectedItem();
            String[] fname = inputSpecifications[0].split("\\.");
            String name = fname[fname.length - 1];
            if (!(newText == null || newText
                    .equals(ConstParameters.NO_SELECTION))) {
                String[] unitName = { newText };
                units.setName(name);
                units.setUnits(unitName);
                inputinterface.replaceEntry(units, this);
                logger.debug("replaced unit at: " + units.getName());
            } else {
                inputinterface.removeEntry(units, this);
                logger.debug("removed unit at: " + units.getName());
            }
        }

    }

    public void inputInterfaceInitializing() {
        ActionListener[] lists = getActionListeners();
        for (int i = 0; i < lists.length; i++) {
            removeActionListener(lists[i]);
        }
        setSelectedIndex(0);
        for (int i = 0; i < lists.length; i++) {
            addActionListener(lists[i]);
        }
    }

    public void inputInterfaceInitialized() {
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        if (evt.getSource() == this || evt.getEntry() == null) {
            return;
        }
        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();

        if (entry.getEntryType() != InputInterfaceEntry.UNITS) {
            return;
        }

        logger.debug("at inputInterfaceEntryChanged");

        InputInterfaceUnits uentry = (InputInterfaceUnits) entry;
        String fullName = tag + ".units";

        java.awt.event.ActionListener[] listeners = getActionListeners();
        for (int i = 0; i < listeners.length; i++) {
            removeActionListener(listeners[i]);
        }

        for (int i = 0; i < inputSpecifications.length; i++) {
            logger.debug("inputSpec : " + inputSpecifications[i]
                    + " uentry : name: " + fullName + " val: "
                    + uentry.getUnits()[0]);
            if (fullName.trim().equalsIgnoreCase(inputSpecifications[i].trim())) {
                setSelectedItem(uentry.getUnits()[0]);
                break;
            }
        }

        for (int i = 0; i < listeners.length; i++) {
            addActionListener(listeners[i]);
        }
    }

    public void writeAllEntries(boolean writeAll) {
        this.writeAll = writeAll;
    }

}
