/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/28, 21:11
!  AUTHOR(S): KOGA, Junichiro
!  File : Rotator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.viewer.view;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * 
 * @author KOGA, Junichiro
 */
public class Rotator extends InternalFrameChase {
    private Logger logger = Logger.getLogger(Rotator.class.getName());
    private J3DPanel parent;

    private JTextField value;
    private JComboBox axis;

    /** Creates a new instance of Rotator */
    public Rotator(J3DPanel parent) {
        super("rotate view", new Dimension(350, 150));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        init();
        setVisible(true);
    }

    private void init() {
        JPanel panel = new JPanel();
        // panel.setLayout(new BoxLayout(panel,BoxLayout.X_AXIS));
        panel.setLayout(new FlowLayout());
        String[] xyz = { "   x-axis   ", "   y-axis   ", "   z-axis   " };
        axis = new JComboBox(xyz);
        JPanel paxis = new JPanel();
        paxis.setBorder(new TitledBorder("select axis"));
        paxis.add(axis);

        value = new JTextField(10);
        JPanel textpanel = new JPanel();
        textpanel.add(value);
        textpanel.setBorder(new TitledBorder("enter value"));
        JButton draw = new JButton("rotate");

        panel.add(paxis);
        panel.add(textpanel);
        panel.add(draw);

        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, BoxLayout.X_AXIS));
        JButton ok = new JButton("ok");
        buttons.add(ok);

        Container cont = super.getContentPane();
        cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));
        cont.add(panel);
        cont.add(buttons);

        draw.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                rotateView();
            }
        });

        ok.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        //
        // Transform3D rot = new Transform3D();
        // rot.rotX(Math.PI/4.0d);
        // tgatom.setTransform(rot);
    }

    private void rotateView() {
        double angle = 0.d;
        String sangle = value.getText();

        try {
            angle = Double.parseDouble(sangle);
        } catch (NumberFormatException nfe) {
            angle = 0.d;
        }

        int selectedAxis = axis.getSelectedIndex();
        Transform3D rot = new Transform3D();
        double ang_in_rad = angle * Math.PI / 180.d;
        if (selectedAxis == 0) {
            rot.rotX(ang_in_rad);
        } else if (selectedAxis == 1) {
            rot.rotY(ang_in_rad);
        } else if (selectedAxis == 2) {
            rot.rotZ(ang_in_rad);
        }

        TransformGroup[] tgs = parent.getRotatingTransform();
        for (int i = 0; i < tgs.length; i++) {
            Transform3D at = new Transform3D();
            tgs[i].getTransform(at);
            at.mul(rot);
            tgs[i].setTransform(at);
        }
        // parent.getScene().setTransform(rot);
        // parent.redraw();
    }

}
