/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : DihedralMeasure.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.viewer.measure;

import javax.media.j3d.BranchGroup;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.measure.Measurable;
import ciss.phase_viewer.acviewer.measure.Measure;
import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementCreator;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.VectorOperations;

public class DihedralMeasure extends Measure {
    private static Logger logger = Logger.getLogger(DihedralMeasure.class
            .getName());
    private final int numAt = 4;

    public DihedralMeasure(Measurable measurable) {
        super(measurable);
    }

    public int getNumberOfNecessaryAtoms() {
        return numAt;
    }

    private BranchGroup getElem() {
        SceneGraphElementCreator creator = measurable.getCreator();
        // SceneGraphElement elem =
        // creator.getSceneGraphElement(xyz[0],xyz[1],xyz[2],xyz[3],result);
        // BranchGroup ret = new BranchGroup();
        // ret.setCapability(BranchGroup.ALLOW_DETACH);
        // ret.addChild(elem);
        return creator.getSceneGraphElement(xyz[0], xyz[1], xyz[2], xyz[3],
                result, id);
    }

    public void draw() {
        if (!validData)
            return;
        MeasureObject elem = (MeasureObject) getElem();
        elem.setAtomVector(atomVectorNow);
        bg.addMeasureObject(elem);
    }

    public void calculate() {
        double[] r21 = new double[3];
        double[] r23 = new double[3];
        double[] r32 = new double[3];
        double[] r34 = new double[3];

        for (int i = 0; i < 3; i++) {
            r21[i] = pos_moto[1][i] - pos_moto[0][i];
            r23[i] = pos_moto[1][i] - pos_moto[2][i];
            r32[i] = pos_moto[2][i] - pos_moto[1][i];
            r34[i] = pos_moto[2][i] - pos_moto[3][i];
        }

        double[] n1 = VectorOperations.getNormalVector(r21, r23);
        double[] n2 = VectorOperations.getNormalVector(r32, r34);

        double costheta = 0.d;
        for (int i = 0; i < 3; i++) {
            costheta += n1[i] * n2[i];
        }

        double theta = Math.toDegrees(Math.acos(costheta));
        result = theta;
        if (!updating) {
            logger.info("dihedral angle calculated from atoms " + id[3] + ", "
                    + id[2] + ", " + id[1] + " and  " + id[0] + " : "
                    + ConstParameters.formater.format(theta) + "");
        }
    }

    public void redraw(int measureIndex, boolean valid) {
        if (!validData)
            return;
        MeasureObject mobj = (MeasureObject) bg.getChild(measureIndex);
        if (!valid) {
            mobj.detach();
            return;
        }
        mobj.setAtoms(new double[][] { xyz[0], xyz[1], xyz[2], xyz[3] });
        mobj.setResult(result);
        mobj.recreate();
        // bg.addMeasureObject((MeasureObject)getElem());
    }

    protected void initUpdate() {
        updating = true;
        // bg.removeAllChildren();
    }

    protected void finalizeUpdate() {
        updating = false;
    }

    public String toString() {
        return "dihedral angle";
    }

}
