/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/06, 15:27
!  AUTHOR(S): KOGA, Junichiro
!  File : VLCAVParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import java.io.IOException;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;

/**
 * vlcav.datat@Cp[XNX.
 * 
 * @author
 */
public class VLCAVParser extends OutputParser implements ProgressInfo {
    private Logger logger = Logger.getLogger(VLCAVParser.class.getName());

    private OutputData outputData;

    /** Creates a new instance of VLCAVParser */
    public VLCAVParser(String fileName) {
        super(fileName);
        outputData = new OutputData();
        outputData.setFileName(fileName);
    }

    public String getCurrentMessage() {
        return null;
    }

    protected boolean parse() {
        if (reader == null)
            return false;
        String line = "";
        dataVector = new Vector();
        try {
            while ((line = reader.readLine()) != null) {
                parseLine(line.trim());
            }
            String[][] data = new String[dataVector.size()][];
            dataVector.copyInto(data);
            outputData.setName("vlocav");
            outputData.setDescription("average of the local potential");
            outputData.setData2D(data);
            addOutputData(outputData);
        } catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        } finally {
            isDone = true;
            try {
                reader.close();
            } catch (IOException ioe) {
                logger.error("failed to finalize read of file: " + fileName);
            }
        }
        return true;
    }

    private Vector dataVector = new Vector();
    private String[] idents = new String[] { "distance along z-axis(A)",
            "Vloc(eV)", "Vfluc", "Efermi(eV)" };

    private void parseLine(String line) {
        if (line.startsWith("#")) {
            outputData.setIdentifier(idents);
            return;
        }
        String[] array = line.split("\\s+");
        dataVector.addElement(array);
    }

}
