/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/01 11:27:02
!  AUTHOR(S): KOGA, Junichiro
!  File : PhaseReportGenerator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.jobcontrolpanel;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.plugins.projectmanipulator.BasicReportGenerator;

public class PhaseReportGenerator extends BasicReportGenerator {
    private Logger logger = Logger.getLogger(PhaseReportGenerator.class
            .getName());

    private boolean nfefnExists = false;

    /*
     * (non-Javadoc)
     * 
     * @see
     * ciss.phase_viewer.plugins.projectmanipulator.BasicReportGenerator#getOthers
     * ()
     */
    protected String getOthers() {
        String ret = "";

        String nfefn = Utils.getFileName("F_ENF", parentDir);
        File nfefnFile = new File(parentDir + "/" + nfefn);
        nfefnExists = nfefnFile.exists() && nfefnFile.length() != 0;

        if (mostRecentStdOutFile == null) {
            ret += "\n";
            ret += "could not find standard output file.\n";
        } else {
            ret += "\n";
            ret += "standard output file : " + mostRecentStdOutFile.getName()
                    + "\n";
            ret += parseStdout(mostRecentStdOutFile);
        }

        if (nfefnExists) {
            ret += "\n";
            ret += "F_ENF file : " + nfefnFile.getName();
            ret += "\n";
            BufferedReader rd = Utils.getReader(nfefnFile.getAbsolutePath());
            String li = "";
            try {
                while ((li = rd.readLine()) != null)
                    ret += li + "\n";
            } catch (IOException ioe) {
                logger.error("failed to read " + nfefnFile.getAbsolutePath());
            } finally {
                try {
                    rd.close();
                } catch (IOException ioe) {
                }
            }
        }
        logger.debug("report:");
        logger.debug(ret);
        return ret;
    }

    private String parseStdout(File stdout) {
        String ret = "";
        BufferedReader reader = Utils.getReader(stdout.getAbsolutePath());
        try {
            String line = "";
            while ((line = reader.readLine()) != null) {
                String foo = parseStdoutLine(line);
                if (foo.trim().length() != 0)
                    ret += parseStdoutLine(line);
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        } finally {
            try {
                reader.close();
            } catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return ret;
    }

    private String parseStdoutLine(String line) {
        String ret = "";

        line = line.trim();

        if (line.startsWith("program start"))
            ret += line + "\n";

        if (line.startsWith("TOTAL ENERGY") && !nfefnExists)
            ret += line + "\n";

        if (line.startsWith("!forc") && !nfefnExists)
            ret += line + "\n";

        return ret;
    }

}
