/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/14, 10:14
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseSplitPane.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.mainpanel;

import java.awt.Component;

import javax.swing.JSplitPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * ChaseNXpJSplitPane
 * 
 * @author
 */
public class ChaseSplitPane extends JSplitPane implements ChaseFrame {
    private Logger logger = Logger.getLogger(ChaseSplitPane.class.getName());

    private String identifier;
    private GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_WINDOW);
    private Component comp;

    /** Creates a new instance of ChaseSplitPane */
    public ChaseSplitPane(String tag, int orientation, Component comp) {
        super();
        setOrientation(orientation);
        this.comp = comp;
        this.identifier = ChaseSplitPane.class.getName() + "." + tag;
    }

    public void init() {
        int width = comp.getSize().width;
        int height = comp.getSize().height;
        int divloc = 0;
        if (getOrientation() == HORIZONTAL_SPLIT) {
            divloc = (int) (width * 0.15);
        } else {
            divloc = (int) (height * 0.83);
        }
        setDividerLocation(divloc);
        try {
            divloc = Integer.parseInt(props.getProperty(identifier
                    + ".divider_location"));
            setDividerLocation(divloc);
        } catch (Exception exc) {
        }
        revalidate();
        repaint();
    }

    public void saveState() {
        props.setProperty(identifier + ".divider_location",
                String.valueOf(getDividerLocation()));
        props.storeProperty();
    }

    public void selected(boolean initialze) {
    }

    public void unselect() {
    }

    public void selected() {
    }

    public boolean isHeavyWeight() {
        return false;
    }

    public ChaseDesktop getDesktop() {
        return (ChaseDesktop) Desk.getDesktop();
    }

}
