/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ImagePrinter.java
!
!  Contact address :  Phase System Consortium
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.imageviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

import javax.swing.JComponent;

public class ImagePrinter extends JComponent implements Printable {

    private Image image;
    private double SCALE = 0.5;

    public ImagePrinter() {
    }

    /**
     * @param image
     *            ImageIuWFNg
     */
    public ImagePrinter(Image image) {
        this.image = image;
    }

    /**
     * ΏۂImageIuWFNgZbg.
     * 
     * @param image
     *            ImageIuWFNg
     * 
     * @uml.property name="image"
     */
    public void setImage(Image image) {
        this.image = image;
    }

    /**
     * OSWprint dialogĂяo.
     */
    public void printImage() {
        PrinterJob job = PrinterJob.getPrinterJob();
        Book book = new Book();
        book.append(this, job.defaultPage());
        job.setPageable(book);
        if (job.printDialog()) {
            try {
                job.print();
            } catch (PrinterException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * ׂ摜v^[ֈ.
     * 
     * @param g
     *            GraphicsIuWFNgɉ摜t@C̃n[hRs[``''.
     * @param format
     *            y[WtH[}bgw肷IuWFNg. 摜t@Cς o͂悤ɃtH[}bg.
     * @param index
     *            uy[Wڂ邩vƂintl. 1y[W̈ɂΉĂȂ.
     */
    public int print(Graphics g, PageFormat format, int index)
            throws PrinterException {
        if (index > 1) {
            return Printable.NO_SUCH_PAGE;
        }

        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);

        double formatWidth = format.getImageableWidth();
        double formatHeight = format.getImageableHeight();

        double scaleWidth = formatWidth / (double) imageWidth;
        double scaleHeight = formatHeight / (double) imageHeight;

        if (scaleWidth <= scaleHeight) {
            SCALE = scaleWidth;
        } else {
            SCALE = scaleHeight;
        }

        // System.out.println("Scale image by: "+SCALE);

        ((Graphics2D) g).translate(format.getImageableX(),
                format.getImageableY());
        ((Graphics2D) g).transform(AffineTransform.getScaleInstance(SCALE,
                SCALE));
        g.drawImage(image, 0, 0, null);
        return Printable.PAGE_EXISTS;
    }

}
