/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ShapeSample.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

/*
 !=======================================================================
 !
 !  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
 !
 !  Created on 2005/11/30, 11:46
 !  AUTHOR(S): KOGA, Junichiro
 !
 !  The license of the code and contact address:
 !  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
 !
 !=======================================================================
 */

package ciss.phase_viewer.graph.plotattributes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;

import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import org.apache.log4j.Logger;

/**
 * uShapẽTvv\. {Iɂorg.jfree.ui.StrokeSamplẽ}l; ҂David Gilbert.
 * 
 * @author
 */
public class ShapeSample extends JComponent implements ListCellRenderer {
    private Logger logger = Logger.getLogger(ShapeSample.class.getName());
    /** Creates a new instance of ShapeSample */

    /** The shape being displayed. */
    private Shape shape;

    /** The preferred size of the component. */
    private Dimension preferredSize;

    /**
     * Creates a ShapeSample for the specified stroke.
     * 
     * @param shape
     *            the sample shape.
     */
    public ShapeSample(final Shape shape) {
        this.shape = shape;
        this.preferredSize = new Dimension(80, 18);
    }

    /**
     * Returns the current Shape object being displayed.
     * 
     * @return the shape.
     */
    public Shape getShape() {
        return this.shape;
    }

    /**
     * Sets the Shape object being displayed.
     * 
     * @param shape
     *            the shape.
     */
    public void setShape(final Shape shape) {
        this.shape = shape;
        repaint();
    }

    /**
     * Returns the preferred size of the component.
     * 
     * @return the preferred size of the component.
     */
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    /**
     * Draws a line using the sample stroke.
     * 
     * @param g
     *            the graphics device.
     */
    public void paintComponent(final Graphics g) {
        final Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.draw(shape);
        g2.fill(shape);

    }

    /**
     * Returns a list cell renderer for the stroke, so the sample can be
     * displayed in a list or combo.
     * 
     * @param list
     *            the list.
     * @param value
     *            the value.
     * @param index
     *            the index.
     * @param isSelected
     *            selected?
     * @param cellHasFocus
     *            focussed?
     * 
     * @return the component for rendering.
     */
    public Component getListCellRendererComponent(final JList list,
            final Object value, final int index, final boolean isSelected,
            final boolean cellHasFocus) {
        if (value instanceof ShapeSample) {
            final ShapeSample in = (ShapeSample) value;
            setShape(in.getShape());
        }
        return this;
    }

}
