/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/09, 18:26
!  AUTHOR(S): KOGA, Junichiro
!  File : FileBrowserUtils.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.filebrowser;

import java.io.File;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.ACIOUtils;
import ciss.phase_viewer.common.CoordsViewerBooter;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.imageviewer.ImageViewerBooter;

/**
 * t@CȂ񂩂ɕ֗ȃ\bhQ.
 * 
 * @author
 */
public class FileBrowserUtils {
    private static Logger logger = Logger.getLogger(FileBrowserUtils.class
            .getName());

    private FileBrowserUtils() {
    }

    /**
     * w̃t@CK؂?vOŋN. ƂΉ摜t@CȂ摜r[A[, qzuȂ猴qzur[A[... ,
     * Ft@Cł̔Ȃ̂ŕK[ł͂Ȃ.
     * 
     * @edi łGfB^[𗘗pꍇ^ɂĂ.
     * @param file
     *            ^[Qbgt@C
     */
    public static void bootProgram(boolean edi, String file) {
        if (edi && !new File(file).isDirectory()) {
            ciss.phase_viewer.common.Utils.bootTextViewer(file);
            return;
        }

        if (!new File(file).isDirectory()
                && ImageViewerBooter.isImageFile(file) && !edi) {
            new Thread(new ImageViewerBooter(file)).start();
            return;
        } else {
            AtomCoords[] coords = null;
            try {
                coords = ACIOUtils.tryToGetInstance(file);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            if (coords != null) {
                logger.debug("coords not null...");
                String dir = new File(file).getParent();
                CoordsViewerBooter bt = new CoordsViewerBooter(new ACVData(
                        new ACVCaller() {
                            public void save(AtomCoords coords) {
                            }
                        }, coords, dir, null, StringConstants.phase_atom_tag),
                        CoordsViewerBooter.INTERNAL_VIEWER);
                bt.boot();
                return;
            }
        }

        if (!new File(file).isDirectory())
            ciss.phase_viewer.common.Utils.bootTextViewer(file);
    }
}
