/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/30, 13:46
!  AUTHOR(S): KOGA, Junichiro
!  File : DefaultFileBrowserPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.filebrowser;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

/**
 * [Jt@C𒭂߂邽߂Defaultt@CuEU[
 * 
 * @author
 */
public class DefaultFileBrowserPanel extends JPanel implements
        FileBrowserTreeListener {
    private Logger logger = Logger.getLogger(DefaultFileBrowserPanel.class
            .getName());
    private String initDir = System.getProperty("user.home");
    private FileBrowserTree local;
    private String nodeClass = "ciss.phase_viewer.filebrowser.DefaultFileBrowserNode";

    /**
     * ftHgRXgN^[. fBNg[System.getProperty("user.home").
     */
    public DefaultFileBrowserPanel() {
        init();
    }

    /**
     * fBNg[w
     * 
     * @param initDir
     *            fBNg[
     */
    public DefaultFileBrowserPanel(String initDir) {
        this.initDir = initDir;
        init();
    }

    /**
     * fBNg[w, ɃJX^m[hg.
     * 
     * @param initDir
     *            fBNg[
     */
    public DefaultFileBrowserPanel(String initDir, String nodeClass) {
        this.initDir = initDir;
        this.nodeClass = nodeClass;
        init();
    }

    private void init() {
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        int os = FileBrowserTree.WINDOWS;
        if (!System.getProperty("os.name").trim().toLowerCase()
                .startsWith("windows")) {
            os = FileBrowserTree.UNIX;
        }
        local = new FileBrowserTree(os, initDir, this, nodeClass, true, false);
        add(local);
    }

    public FileBrowserTree getFileBrowserTree() {
        return local;
    }

    public void addFileBrowserTreeListener(FileBrowserTreeListener listener) {
        if (local != null) {
            local.addFileBrowserListener(listener);
        }
    }

    public void directoryHasChanged(FileBrowserEvent e) {
    }

    public String[] getSelectedPaths() {
        return local.getSelectedPaths();
    }

}
