/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : NfdynmParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.util.StringTokenizer;

public class NfdynmParser extends OldOutputParser {

    /** number of columns */
    private int numColumns;

    /** number of rows */
    private int numRows;

    /** sharp */
    private String SHARP = "#";

    /** store unusual identifiers */
    private String iter_ion_str = new String();
    private String iter_total_str = new String();

    /**
     * Ńt@Cƃwb_[w肷.
     * 
     * @param filename
     *            nfenf file to be parsed
     */
    public NfdynmParser(String filename) {
        super(filename);
        setNumColumns(9);
    }

    /**
     * ̃t@C̃p[X@w肷. 𕪉, KvɉăJɑ߂΂悢.
     * 
     * @param str
     *            p[X.
     */
    public void parseString(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String strdata = new String();
        boolean bloopisData = false;
        boolean bColumnName = true;

        if (str.trim().startsWith(SHARP)) {
            addHeader(str);
            addHeader(OldOutputParser.CR);
            bloopisData = false;
        } else if (str.trim().startsWith("cps")) {
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                if (strdata.trim().startsWith("(") && bColumnName) {
                    addColumnName("iter_ion");
                    addColumnName("iter_total");
                    addColumnName("atom_label");
                    addColumnName("pos(x)");
                    addColumnName("pos(y)");
                    addColumnName("pos(z)");
                    addColumnName("forc(x)");
                    addColumnName("forc(y)");
                    addColumnName("forc(z)");
                    bColumnName = false;
                } else if (strdata.trim().startsWith("=")) {
                    iter_ion_str = st.nextToken().trim();
                    iter_total_str = st.nextToken().trim();
                }
            }
            bloopisData = false;
        } else {
            addDataColumn(iter_ion_str);
            addDataColumn(iter_total_str);
            while (st.hasMoreTokens()) {
                strdata = st.nextToken();
                addDataColumn(strdata);
            }
            bloopisData = true;
        }
        if (bloopisData) {
            addDataRow();
        }

    }

}
