/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : CheckBoxTableCellRenderer.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import org.apache.log4j.Logger;

public class CheckBoxTableCellRenderer extends JCheckBox implements
        TableCellRenderer {
    private Logger logger = Logger.getLogger(CheckBoxTableCellRenderer.class
            .getName());

    /** ^Cĝݒ` */
    public CheckBoxTableCellRenderer() {
        super();
        setHorizontalAlignment(JLabel.CENTER);
    }

    public CheckBoxTableCellRenderer(String text) {
        super();
        super.setText(text);
        setHorizontalAlignment(JLabel.CENTER);
    }

    /** ̏ꍇ̃e[uZ_[̏ */
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            // setForeground(table.getSelectionForeground());
            // setBackground(table.getSelectionBackground());
        } else {
            // setForeground(table.getForeground());
            // setBackground(table.getBackground());
        }

        try {
            boolean bvalue = false;
            if (value instanceof String) {
                String svalue = (String) value;
                bvalue = svalue.equalsIgnoreCase("on") || svalue.equals("1")
                        || svalue.equalsIgnoreCase("yes");
                this.setSelected(bvalue);
            } else if (value instanceof Boolean) {
                this.setSelected(((Boolean) value).booleanValue());
            } else {
                this.setSelected(false);
            }
        } catch (NullPointerException npe) {
        } catch (ClassCastException cle) {
            logger.error("failed to render: " + value);
        }

        return this;
    }

}
