package ciss.phase_viewer.atomcoord.pmodel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class PM {
    public static void main(String[] args) throws PmodelException, IOException {
        int ndb, choice = -2;

        if (args.length != 1) {
            System.out.println("Usage: java PM CIF_file_name");
            System.exit(1);
        }

        Pmodel unitCell = new Pmodel();

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String str;

        String[] titles = Cif.getDataBlockTitle(args[0]);
        ndb = titles.length;
        for (int i = 0; i < ndb; ++i)
            System.out.println(i + 1 + "  " + titles[i]);
        // <SELECT_DATA_BLOCK>
        if (ndb == 0) {
            System.out.println("Warning : No 'data_' tag found.");
        } else if (ndb == 1) {
            ; // nothing to do
        } else {
            // SELECT
            System.out.println("Number of data block in the CIF: " + ndb);
            str = br.readLine(); // INPUT DATA BLOCK NUMBER
            ndb = Integer.parseInt(str);
            System.out.println("Selected data block: " + ndb);
        }
        // </SELECT_DATA_BLOCK>

        System.out.println("CIF file name: " + args[0]);
        unitCell.readCIF(args[0], ndb); // read CIF

        System.out.println("<SpaceGroup>");
        if (unitCell.getNumSymmetryEquivPosInCif() > 1) {
            System.out.println("use equiv_pos_as_xyz");
            try {
                unitCell.makeSpaceGroup();
            } catch (PmodelException ex) {
                System.out.println("Invalid operator(s) in " + args[0] + ".");
                throw ex;
            }
        } else if (unitCell.getIntTablesNum() > 0) {
            System.out.println("use int_tables_num: "
                    + unitCell.getIntTablesNum());
            choice = SpaceGroup.getMaxChoice(unitCell.getIntTablesNum());
            // <SELECT_CHOICE>
            if (choice > 1) { // SELECT
                System.out.println("Maximum number of CHOICE: " + choice);
                str = br.readLine(); // INPUT CHOICE
                choice = Integer.parseInt(str);
                System.out.println("CHOICE: " + choice);
            }
            --choice;
            // </SELECT_CHOICE>
            unitCell.makeSpaceGroup(choice);
        } else {
            System.out.println("Cannot detect symmetry informations.");
            PmodelException ex = new PmodelException();
            throw ex;
        }
        System.out.println("</SpaceGroup>");

        str = br.readLine(); // WAIT

        unitCell.makeLattice(); // EXPAND ATOM(S)

        // <RESULTS>
        double[] cellAngle = unitCell.getCellAngle();
        double[] cellLength = unitCell.getCellLength();
        String hm = unitCell.getHermannMauguin();
        double[][] position = unitCell.getInternalPosition();
        String[] element = unitCell.getSymbol();
        String[] alias = unitCell.getAlias();

        System.out.println("Space Group Number: " + unitCell.getIntTablesNum());
        if (choice > 0)
            System.out.println("Number of Choice  : " + ++choice);
        System.out.println("Hermann-Mauguin symbol: " + hm);

        System.out.println("Cell Length:");
        System.out.printf("a = %f, b = %f, c = %f\n", cellLength[0],
                cellLength[1], cellLength[2]);

        System.out.println("Cell Angle:");
        System.out.printf("alpha = %f, beta = %f, gamma = %f\n", cellAngle[0],
                cellAngle[1], cellAngle[2]);

        System.out.println("Cell Vector:");
        double[][] cellVec = unitCell.getCellVec();
        for (int i = 0; i < 3; ++i) {
            System.out.printf("%c_vector = ", 'a' + i);
            for (int j = 0; j < 3; ++j)
                System.out.printf("%17.12f", cellVec[i][j]);
            System.out.printf("\n");
        }

        int numAtom = unitCell.getNumberOfAtoms();
        System.out.println("Number of Atoms: " + numAtom);

        System.out.println("Internal Position:");
        for (int i = 0; i < numAtom; ++i)
            System.out.printf("%8s%8s%16.10f%16.10f%16.10f\n", element[i],
                    alias[i], position[i][0], position[i][1], position[i][2]);
        // </RESULTS>
    }
}
