/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2007/01/04 14:36:56
!  AUTHOR(S): KOGA, Junichiro
!  File : ExportFileChooser.java
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.atomcoord.io;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;

import javax.swing.JFileChooser;

import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.main.PluginLoader;

public class ExportFileChooser extends ChaseFileChooser implements
		PropertyChangeListener {
	private org.apache.log4j.Logger logger = org.apache.log4j.Logger
			.getLogger(ExportFileChooser.class.getName());

	private Exportable caller;

	private Exporter[] exporters;

	private AtomCoords[] targetCoords;

	private Component parent;

	public ExportFileChooser(Exportable caller, Component parent) {
		super(ChaseFileChooser.atom, true);

		this.caller = caller;
		this.parent = parent;
		this.targetCoords = caller.getCoordsToExport();

		setDialogType(JFileChooser.CUSTOM_DIALOG);
		setDialogTitle("select atomic configuration file");
		setFileSelectionMode(JFileChooser.FILES_ONLY);
		setAcceptAllFileFilterUsed(false);
		addPropertyChangeListener(this);
		init();
	}

	private String atomCoordsFile;

	private void init() {
		createExporters();

		for (int i = 0; i < exporters.length; i++)
			addChoosableFileFilter(exporters[i].getFileFilter());
		setFileFilter(getChoosableFileFilters()[0]);

		if (showSaveDialog(parent) != APPROVE_OPTION)
			return;

		atomCoordsFile = getSelectedFile().getAbsolutePath();

		int index = getSelectedFileFilterIndex();
		if (!exporters[index].hasOptions()) {
			exporters[index].writeAtomCoordsTo(targetCoords, atomCoordsFile);
			caller.coordsExported(targetCoords, exporters[index].getType(),
					atomCoordsFile);
		} else {
			exporters[index].createOptionsPanel(false, this, atomCoordsFile);
		}
	}

	private void createExporters() {
		Document doc = ciss.phase_viewer.jdom.XMLUtils
				.getDocumentFromURL(AtomCoordsIO.SUPPORTED_FILETYPE);
		Element root = doc.getRootElement();
		java.util.List list = root.getChildren("exporter");
		Vector vec = new Vector();
		for (int i = 0; i < list.size(); i++) {
			String loadClass = ((Element) list.get(i))
					.getChildTextTrim("loadclass");
			vec.addElement(loadClass);
		}
		exporters = new Exporter[vec.size()];
		for (int i = 0; i < vec.size(); i++) {
			String load = (String) vec.get(i);
			exporters[i] = (Exporter) PluginLoader.instantiate(load, null);
		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		try {
			if (evt != null && evt.getPropertyName().equals("fileFilterChanged")) {
				int index = getSelectedFileFilterIndex();
				String defname = exporters[index].getDefaultFileName();
				if (defname != null) {
					setSelectedFile(new File(defname));
				} else
					setSelectedFile(new File(""));
			}
			int index = getSelectedFileFilterIndex();
			if (atomCoordsFile == null)
				return;
			exporters[index].writeAtomCoordsTo(targetCoords, atomCoordsFile);
			if (caller != null)
				caller.coordsExported(targetCoords, exporters[index].getType(),
						atomCoordsFile);
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}

}
