/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/24, 16:45
!  AUTHOR(S): KOGA, Junichiro
!  File : CubeImporter.java
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord.io;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cube2AtomCoords;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * Gaussian Cube`̃t@CC|[g.
 *
 * @author
 */
public class CubeImporter implements Importer {
    private Logger logger = Logger.getLogger(CubeImporter.class.getName());

    /** Creates a new instance of CubeImporter */
    public CubeImporter() {
    }

    private int interpolationScheme = VolumetricData.LOG;

    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        return getFileFilter().accept(new File(fileName));
    }

    public ciss.phase_viewer.atomcoord.AtomCoords[] getAtomCoordsFrom(
            String fileName) {
        Cube2AtomCoords c2a = new Cube2AtomCoords(fileName);
        AtomCoords coords = c2a.getAtomCoords();
        coords.getChargeDensity().setInterpolationScheme(interpolationScheme);
        return new AtomCoords[] { coords };
    }

    public void setOptions(java.util.HashMap options) {
    }

    private PropertyChangeListener listener;

    public void createOptionsPanel(boolean heavy,
            PropertyChangeListener listener, String fileName) {
        this.listener = listener;
        OptPanel panel = new OptPanel();
    }

    class OptPanel extends InternalFrameChase {
        private JComboBox interp;

        private String[] interpChoices = { "log", "linear" };

        private JButton ok;

        OptPanel() {
            super("options", new Dimension(180, 130));
            getContentPane().setLayout(
                    new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
            init();
            setVisible(true);
        }

        private void init() {
            interp = new JComboBox(interpChoices);
            JPanel pinterp = new JPanel();
            pinterp.setBorder(new javax.swing.border.TitledBorder(
                    "select interpolation type"));
            pinterp.add(interp);
            JPanel pbtn = new JPanel();
            ok = new JButton("ok");
            pbtn.add(ok);
            getContentPane().add(pinterp);
            getContentPane().add(pbtn);

            ok.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (interp.getSelectedIndex() == 1)
                            interpolationScheme = VolumetricData.LINEAR;
                        if (interp.getSelectedIndex() == 0)
                            interpolationScheme = VolumetricData.LOG;
                        dispose();
                        listener.propertyChange(null);
                    } catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
        }
    }

    public boolean hasOptions() {
        return true;
    }

    public String getType() {
        return "Gaussian Cube";
    }

    public javax.swing.filechooser.FileFilter getFileFilter() {
        return new CubeFileFilter();
    }

	@Override
	public String getDefaultFileName() {
		return "nfchr.cube";
	}

}

class CubeFileFilter extends javax.swing.filechooser.FileFilter {
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }

        String fileName = f.getName().toLowerCase();

        if (fileName != null) {
            if (fileName.endsWith(".cube")) {
                return true;
            } else {
                return false;
            }
        }

        return false;
    }

    public String getDescription() {
        return "Gaussian Cube file (*.cube)";
    }

}
