/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/25, 19:20
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseImporter.java
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord.io;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.jdom.XMLUtils;

/**
 * uChaseqzu`vɂ.
 *
 * @author
 */
public class ChaseImporter implements Importer {
    private Logger logger = Logger.getLogger(ChaseImporter.class.getName());

    /** Creates a new instance of ChaseImporter */
    public ChaseImporter() {
    }

    public ciss.phase_viewer.atomcoord.AtomCoords[] getAtomCoordsFrom(
            String fileName) {
        Document document = XMLUtils.getDocumentFromFile(new File(fileName));
        Element root = document.getRootElement();
        java.util.List frame = root.getChildren("frame");
        if (frame == null || frame.size() == 0) {
            logger.error("no frame found in file!");
            return null;
        }
        AtomCoords[] coords = new AtomCoords[frame.size()];
        for (int i = 0; i < frame.size(); i++) {
            coords[i] = new AtomCoords();
            Element fr = (Element) frame.get(i);
            String iscart = fr.getAttribute("iscart").getValue();
            coords[i].isCart(new Boolean(iscart).booleanValue());
            String length = fr.getAttribute("lengthunit").getValue();
            int un = coords[i].getUnitInt(length);
            coords[i].setUnit(un);

            Element atlist = fr.getChild("atomlist");
            AtomList list = coords[i].getAtomList();
            list.createFrom(atlist);
            Element elemcell = fr.getChild("cell");
            Cell[] cell = Cell.createFrom(elemcell);
            coords[i].setCell(cell);
        }
        return coords;
    }

    public void createOptionsPanel(boolean heavy,
            PropertyChangeListener listener, String fileName) {
    }

    public boolean hasOptions() {
        return false;
    }

    public String getType() {
        return "phase-viewer";
    }

    public javax.swing.filechooser.FileFilter getFileFilter() {
        return new ChaseFileFilter();
    }

    public void setOptions(HashMap options) {
    }

    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        return getFileFilter().accept(new File(fileName));
    }

	@Override
	public String getDefaultFileName() {
		return "chase.xml";
	}

}
