/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/30, 21:12
!  AUTHOR(S): KOGA, Junichiro
!  File : AtomSphere.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import java.util.Enumeration;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;

import org.apache.log4j.Logger;

import com.sun.j3d.utils.geometry.Sphere;

/**
 * uqv`悷邽߂Primitive
 * 
 * @author
 */
public class AtomSphere extends Sphere {
    private Logger logger = Logger.getLogger(AtomSphere.class.getName());
    private AtomObject obj;

    /** Creates a new instance of AtomSphere */
    public AtomSphere(float radius, int primflags, int divisions,
            Appearance ap, AtomObject obj) {
        super(radius, primflags, divisions, ap);
        getShape().setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
        getShape().setCapability(Shape3D.ALLOW_COLLISION_BOUNDS_READ);
        getShape().setCapability(Shape3D.ALLOW_COLLISION_BOUNDS_WRITE);
        getShape().setCapability(Shape3D.ALLOW_GEOMETRY_READ);
        getShape().setCapability(Shape3D.ALLOW_APPEARANCE_READ);
        // getShape().getGeometry().setCapability(GeometryArray.ALLOW_COORDINATE_READ);
        // getShape().getGeometry().setCapability(GeometryArray.ALLOW_FORMAT_READ);
        // getShape().getGeometry().setCapability(GeometryArray.ALLOW_COUNT_READ);
        // getShape().getGeometry().setCapability(GeometryArray.ALLOW_NORMAL_READ);
        try {
            Enumeration enume = getShape().getAllGeometries();
            while (enume.hasMoreElements()) {
                ((Geometry) enume.nextElement())
                        .setCapability(Geometry.ALLOW_INTERSECT);
            }
        } catch (Exception exc) {
        }
        setCapability(Shape3D.ALLOW_BOUNDS_READ);
        setCapability(Shape3D.ALLOW_BOUNDS_WRITE);
        this.obj = obj;
    }

    public AtomObject getAtomObject() {
        return this.obj;
    }

}
